% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.Data.r
\name{MVP.Data.Hapmap2MVP}
\alias{MVP.Data.Hapmap2MVP}
\title{MVP.Data.Hapmap2MVP: To transform Hapmap data to MVP package
Author: Haohao Zhang
Build date: Sep 12, 2018}
\usage{
MVP.Data.Hapmap2MVP(hmp_file, out = "mvp", maxLine = 10000,
  type.geno = "char", threads = 1, verbose = TRUE)
}
\arguments{
\item{hmp_file}{Genotype in Hapmap format}

\item{out}{the name of output file}

\item{maxLine}{the max number of line to write to big matrix for each loop}

\item{type.geno}{the type of genotype elements}

\item{threads}{number of thread for transforming}

\item{verbose}{whether to print the reminder}
}
\value{
number of individuals and markers.
Output files:
genotype.desc, genotype.bin: genotype file in bigmemory format
phenotype.phe: ordered phenotype file, same taxa order with genotype file
map.map: SNP information
}
\description{
MVP.Data.Hapmap2MVP: To transform Hapmap data to MVP package
Author: Haohao Zhang
Build date: Sep 12, 2018
}
\examples{
hapmapPath <- system.file("extdata", "03_hapmap", "mvp.hmp.txt", package = "rMVP")

MVP.Data.Hapmap2MVP(hapmapPath, tempfile("outfile"))

}
