% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw_hscv.R
\name{bw_hscv}
\alias{bw_hscv}
\title{Smoothed cross-validation bandwidth selector.}
\usage{
bw_hscv(x)
}
\arguments{
\item{x}{2d matrix of data values.}
}
\value{
A numeric vector of estimated x and y bandwidths. Must subset your data if you wish to obtain group specific bandwidths.
}
\description{
A simple wrapper for the ks::Hscv function.
}
\examples{
data("rodents")
# Subset the data for a single species
spec1<- rodents[rodents$Species == "Species1", ]
# Calculate the bandwidth
bw_hscv(as.matrix(spec1[, c("Ave_C", "Ave_N")]))
}
\author{
Shannon E. Albeke, Wyoming Geographic Information Science Center, University of Wyoming
}
