% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{symm_plot}
\alias{symm_plot}
\title{Plot the symmetrized glucose values}
\usage{
symm_plot(x, times, unit = "mg")
}
\arguments{
\item{x}{vector of glucose readings}

\item{times}{vector of corresponding times, in minutes}

\item{unit}{"mg" if the units are mg/dL or "mmol" if the units are mmol/L. Null value is "mg".}
}
\value{
A plot of symmetrized glucose values over time. These symmetrized values are used in the calculation of BGI and ADRR.
}
\description{
Plot the symmetrized glucose values
}
\examples{
symm_plot(x=c(rep(100, 10),rep(120, 10), 105, 85), times=seq(0, 1260, 60), unit='mg')
}
