% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{avisMap}
\alias{avisMap}
\title{Renders a map for the observations provided in 'obs'}
\usage{
avisMap(obs, label = "", maptype = "admin")
}
\arguments{
\item{obs}{set of observations returned by any of the avisQueryXXX functions}

\item{label}{label for the map. E.g. "Occurrences of Pica pica in Proyecto AVIS"}

\item{maptype}{Available types of map are 'admin',
administrative provinces of Spain (by default)
or 'phys, physical map of Spain.}
}
\value{
a plot with the occurrences of the species in the Iberian Peninsula. Maps have high resolution, so they could be printed.
}
\description{
This function should be used with avisQuerySpecies, to set a particular
query (with or without filters) and get the observations that we want to map.
It just allow to map one species. See avisMapSpecies for multiple maps.
}
\examples{
\dontrun{
obs<- avisQuerySpecies ("Pica pica", args = list(habitat = "bosque"))
avisMap(obs, label = "Pica pica")
avisMap(obs, label = "Pica pica", maptype = "phys")
}
}

