% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set_suboptimal_minutes}
\alias{set_suboptimal_minutes}
\title{Set suboptimal minutes}
\usage{
set_suboptimal_minutes(
  r5r_core,
  suboptimal_minutes,
  fare_structure,
  shortest_path
)
}
\arguments{
\item{r5r_core}{An object to connect with the R5 routing engine, created with
\code{\link[=setup_r5]{setup_r5()}}.}

\item{suboptimal_minutes}{A number.}

\item{fare_structure}{A fare structure object, following the convention
set in \code{\link[=setup_fare_structure]{setup_fare_structure()}}. This object describes how transit fares
should be calculated. Please see the fare structure vignette to
understand how this object is structured:
\code{vignette("fare_structure", package = "r5r")}.}

\item{shortest_path}{A logical.}
}
\value{
Invisibly returns \code{TRUE}.
}
\description{
Sets the number of suboptimal minutes considered in \code{\link[=detailed_itineraries]{detailed_itineraries()}}
routing. From R5 documentation: "This parameter compensates for the fact that
GTFS does not contain information about schedule deviation (lateness). The
min-max travel time range for some trains is zero, since the trips are
reported to always have the same timings in the schedule. Such an option
does not overlap (temporally) its alternatives, and is too easily eliminated
by an alternative that is only marginally better. We want to effectively
push the max travel time of alternatives out a bit to account for the fact
that they don't always run on schedule".
}
\seealso{
Other setting functions: 
\code{\link{set_breakdown}()},
\code{\link{set_cutoffs}()},
\code{\link{set_expanded_travel_times}()},
\code{\link{set_fare_cutoffs}()},
\code{\link{set_fare_structure}()},
\code{\link{set_max_fare}()},
\code{\link{set_max_lts}()},
\code{\link{set_max_rides}()},
\code{\link{set_monte_carlo_draws}()},
\code{\link{set_n_threads}()},
\code{\link{set_output_dir}()},
\code{\link{set_percentiles}()},
\code{\link{set_progress}()},
\code{\link{set_speed}()},
\code{\link{set_time_window}()},
\code{\link{set_verbose}()}
}
\concept{setting functions}
\keyword{internal}
