% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_suboptimal_minutes}
\alias{set_suboptimal_minutes}
\title{Set suboptimal minutes}
\usage{
set_suboptimal_minutes(r5r_core, suboptimal_minutes)
}
\arguments{
\item{r5r_core}{rJava object to connect with R5 routing engine}

\item{suboptimal_minutes}{numeric. The number of suboptimal minutes in a public transport
point-to-point query. From R5's documentation:
This parameter compensates for the fact that GTFS does not
contain information about schedule deviation (lateness).
The min-max travel time range for some trains is zero, since
the trips are reported to always have the same timings in the
schedule. Such an option does not overlap (temporally) its
alternatives, and is too easily eliminated by an alternative
that is only marginally better. We want to effectively push
the max travel time of alternatives out a bit to account for
the fact that they don't always run on schedule.}
}
\value{
No return value, called for side effects.
}
\description{
Set suboptimalMinutes parameter in R5.
}
\seealso{
Other support functions: 
\code{\link{assert_breakdown_stat}()},
\code{\link{assert_decay_function}()},
\code{\link{assert_points_input}()},
\code{\link{check_connection}()},
\code{\link{filename_from_metadata}()},
\code{\link{find_snap}()},
\code{\link{posix_to_string}()},
\code{\link{select_mode}()},
\code{\link{set_max_lts}()},
\code{\link{set_max_rides}()},
\code{\link{set_max_street_time}()},
\code{\link{set_n_threads}()},
\code{\link{set_progress}()},
\code{\link{set_speed}()},
\code{\link{set_verbose}()},
\code{\link{stop_r5}()},
\code{\link{street_network_to_sf}()},
\code{\link{transit_network_to_sf}()}
}
\concept{support functions}
