/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.analysis.BackendVersion;
import com.conveyal.kryo.TIntArrayListSerializer;
import com.conveyal.kryo.TIntIntHashMapSerializer;
import com.conveyal.r5.kryo.KryoNetworkSerializer;
import com.conveyal.r5.transit.TransportNetwork;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.ExternalizableSerializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.BitSet;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.SerializingInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R5Network {
    private static final Logger LOG = LoggerFactory.getLogger(R5Network.class);

    public static TransportNetwork checkAndLoadR5Network(String dataFolder) throws FileNotFoundException {
        File file = new File(dataFolder, "network.dat");
        if (!file.isFile()) {
            R5Network.createR5Network(dataFolder);
        } else if (!R5Network.checkR5NetworkVersion(dataFolder)) {
            R5Network.createR5Network(dataFolder);
        }
        return R5Network.loadR5Network(dataFolder);
    }

    public static TransportNetwork loadR5Network(String dataFolder) {
        try {
            return KryoNetworkSerializer.read((File)new File(dataFolder, "network.dat"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void createR5Network(String dataFolder) {
        File[] mapdbFiles;
        File dir = new File(dataFolder);
        for (File file : mapdbFiles = dir.listFiles((d, name) -> name.contains(".mapdb"))) {
            file.delete();
        }
        TransportNetwork tn = TransportNetwork.fromDirectory((File)new File(dataFolder));
        try {
            KryoNetworkSerializer.write((TransportNetwork)tn, (File)new File(dataFolder, "network.dat"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkR5NetworkVersion(String dataFolder) throws FileNotFoundException {
        LOG.info("Reading transport network...");
        File file = new File(dataFolder, "network.dat");
        Input input = new Input((InputStream)new FileInputStream(file));
        Kryo kryo = R5Network.makeKryo();
        byte[] header = new byte[KryoNetworkSerializer.HEADER.length];
        input.read(header, 0, header.length);
        if (!Arrays.equals(KryoNetworkSerializer.HEADER, header)) {
            throw new RuntimeException("Unrecognized file header. Is this an R5 Kryo network?");
        }
        String version = (String)kryo.readObject(input, String.class);
        String commit = (String)kryo.readObject(input, String.class);
        LOG.info("Loading {} file saved by R5 version {} commit {}", new Object[]{new String(header), version, commit});
        input.close();
        if (!BackendVersion.instance.version.equals(version)) {
            LOG.error(String.format("File version %s is not compatible with this R5 version %s", version, BackendVersion.instance.version));
            return false;
        }
        return true;
    }

    private static Kryo makeKryo() {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(false);
        kryo.setReferences(true);
        kryo.addDefaultSerializer(TPrimitiveHash.class, ExternalizableSerializer.class);
        kryo.register(TIntArrayList.class, (Serializer)new TIntArrayListSerializer());
        kryo.register(TIntIntHashMap.class, (Serializer)new TIntIntHashMapSerializer());
        kryo.register(BitSet.class, (Serializer)new JavaSerializer());
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new SerializingInstantiatorStrategy()));
        return kryo;
    }
}

