% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_changepars.R
\name{SS_changepars}
\alias{SS_changepars}
\title{Change parameters, bounds, or phases in the control file.}
\usage{
SS_changepars(dir = NULL, ctlfile = "control.ss_new",
  newctlfile = "control_modified.ss", linenums = NULL, strings = NULL,
  newvals = NULL, repeat.vals = FALSE, newlos = NULL, newhis = NULL,
  estimate = FALSE, verbose = TRUE, newphs = NULL)
}
\arguments{
\item{dir}{Directory with control file to change.}

\item{ctlfile}{Control file name. Default="control.ss_new".}

\item{newctlfile}{Name of new control file to be written.
Default="control_modified.ss".}

\item{linenums}{Line numbers of control file to be modified. Either this or
the \code{strings} argument are needed. Default=NULL.}

\item{strings}{Strings (with optional partial matching) indicating which
parameters to be modified. This is an alternative to \code{linenums}.
\code{strings} correspond to the commented parameter names included in
\code{control.ss_new}, or whatever is written as comment at the end
of the 14 number parameter lines. Default=NULL.}

\item{newvals}{Vector of new parameter values. Default=NULL.
The vector can contain \code{NA} values, which will assign the original
value to the given parameter but change the remainder parameters, where
the vector of values needs to be in the same order as either
\code{linenums} or \code{strings}.}

\item{repeat.vals}{If multiple parameter lines match criteria, repeat the
\code{newvals} input for each line.}

\item{newlos}{Vector of new lo bounds. Default=NULL.
The vector can contain \code{NA} values, which will assign the original
value to the given parameter but change the remainder parameters, where
the vector of values needs to be in the same order as either
\code{linenums} or \code{strings}.}

\item{newhis}{Vector of new hi bounds. Must be the same length as newhis
Default=NULL.
The vector can contain \code{NA} values, which will assign the original
value to the given parameter but change the remainder parameters, where
the vector of values needs to be in the same order as either
\code{linenums} or \code{strings}.}

\item{estimate}{Vector of TRUE/FALSE for which changed parameters are to be
estimated. Default=FALSE. Can also be \code{NULL}.}

\item{verbose}{More detailed output to command line. Default=TRUE.}

\item{newphs}{Vector of new phases. Can be a single value, which will be
repeated for each parameter, the same length as newvals, where each
value corresponds to a single parameter, or \code{NULL}, where the
phases will not be changed. If one wants to strictly turn parameters
on or off and not change the phase in which they are estimated use
\code{estimate = TRUE} or \code{estimate = FALSE}, respectively.
The vector can contain \code{NA} values, which will assign the original
value to the given parameter but change the remainder parameters, where
the vector of values needs to be in the same order as either
\code{linenums} or \code{strings}.}
}
\description{
Loops over a subset of control file to change parameter lines.
Current initial value, lower and upper bounds, and phase can be modified,
but function could be expanded to control other columns.
Depends on \code{\link{SS_parlines}}.
Used by \code{\link{SS_profile}} and the \pkg{ss3sim} package.
}
\examples{

\dontrun{
SS_changepars(dir='Y:/ss/SSv3.03a/Simple/',ctlfile='Control.SS_New',
              strings=c('SR_steep','SR_sigmaR'),newvals=c(.35,.6))
# [1] wrote new file to Control_Modified.SS
#    oldvals newvals oldphase newphase     comment
# 1 0.609048    0.35        4       -4  # SR_steep
# 2 0.600000    0.60       -4       -4 # SR_sigmaR
}

}
\author{
Ian Taylor, Christine Stawitz
}
\seealso{
\code{\link{SS_parlines}}, \code{\link{SS_profile}}
}
\keyword{data}
\keyword{manip}

