% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style.R
\name{m_style_label}
\alias{m_style_label}
\title{Specify Styling for Labels}
\usage{
m_style_label(
  font = "sans-serif",
  fontSize = 18,
  fontColor = "white",
  fontOpacity = 1,
  backgroundColor = "black",
  backgroundOpacity = 1,
  borderOpacity = 1,
  borderThickness = 0,
  borderColor = backgroundColor,
  inFront = TRUE,
  showBackground = TRUE,
  fixed = FALSE,
  alignment = c("topLeft", "topCenter", "topRight", "centerLeft", "center",
    "centerRight", "bottomLeft", "bottomCenter", "bottomRight"),
  position = NULL,
  frame = NULL
)
}
\arguments{
\item{font}{Font name, default sans-serif.}

\item{fontSize}{Height of text, default 18.}

\item{fontColor}{Font color, default white.}

\item{fontOpacity}{Font opacity, default 1.}

\item{backgroundColor}{Color of background, default black.}

\item{backgroundOpacity}{Opacity of background, default 1.}

\item{borderOpacity}{Opacity of border, default 1.}

\item{borderThickness}{Line width of border around label, default 0.}

\item{borderColor}{Color of border, default backgroundColor.}

\item{inFront}{Logical, if \code{TRUE} always put in front of model.}

\item{showBackground}{Logical, show background rounded rectangle, default
\code{TRUE}.}

\item{fixed}{Logical, setes the label to change with the model when zooming.}

\item{alignment}{String, how to orient the label with respect to position:
'topLeft' (default), 'topCenter', 'topRight', 'centerLeft', 'center',
'centerRight', 'bottomLeft', 'bottomCenter', 'bottomRight'.}

\item{position}{x,y,z coordinates for label (for custom positioning).}

\item{frame}{If set, only display in this frame of an animation.}
}
\description{
Styling options for the labels. Used inside \code{m_add_label()},
\code{m_add_res_labels()} and \code{m_add_property_labels()}.
}
\examples{
r3dmol() \%>\%
  m_add_model(data = pdb_1j72, format = "pdb") \%>\%
  m_set_style(style = m_style_stick()) \%>\%
  m_add_res_labels(style = m_style_label(
    fontSize = 14,
    backgroundColor = "green"
  )) \%>\%
  m_zoom_to()
}
