% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_sizeDist.R
\name{prepare_sizeDist}
\alias{prepare_sizeDist}
\title{Prepare parameters table}
\usage{
prepare_sizeDist(size_dist = NULL, sp_names = c("Fagus sylvatica",
  "Pinus sylvestris"))
}
\arguments{
\item{size_dist}{table containing the information about size distribution to be modified. Values that are not provided are replaced by defaults.
\itemize{
\item parameter: name of the parameter, must be consistent in naming with \code{\link{i_sizeDist}}.
\item species: each column must correspond to species/cohort id/name, as defined in \code{species} table.
}}

\item{sp_names}{names of the species / cohorts used for the simulations.The `sp_names` must be identical to those from \code{species} table.}
}
\value{
a data.frame with 47 rows and columns corresponding to each species.
}
\description{
Prepares the parameters table, by either replicating the defaults or replicating defaults for each of the species.
}
\details{
This function prepares the parameter table for \code{\link{run_3PG}}.
}
\examples{
# replace some
prepare_sizeDist( size_dist = d_sizeDist[1:4,],
  sp_names = c('Fagus sylvatica', 'Pinus sylvestris' ))

# Make default
prepare_sizeDist( size_dist = NULL, sp_names = c('Quercus', 'Abies'))

}
\seealso{
\code{\link{run_3PG}}, \code{\link{prepare_input}}, \code{\link{prepare_parameters}}, \code{\link{prepare_thinning}}, \code{\link{prepare_climate}}
}
