/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.nearest_neighbor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.nearest_neighbor.KNNInputs;
import org.dmg.pmml.nearest_neighbor.PMMLAttributes;
import org.dmg.pmml.nearest_neighbor.PMMLElements;
import org.dmg.pmml.nearest_neighbor.TrainingInstances;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Since;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="NearestNeighborModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "trainingInstances", "comparisonMeasure", "knnInputs", "modelVerification"})
@JsonRootName(value="NearestNeighborModel")
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "numberOfNeighbors", "continuousScoringMethod", "categoricalScoringMethod", "instanceIdVariable", "threshold", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "trainingInstances", "comparisonMeasure", "knnInputs", "modelVerification"})
@Added(value=Version.PMML_4_1)
public class NearestNeighborModel
extends Model
implements HasExtensions<NearestNeighborModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="numberOfNeighbors", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfNeighbors")
    private Integer numberOfNeighbors;
    @XmlAttribute(name="continuousScoringMethod")
    @JsonProperty(value="continuousScoringMethod")
    private ContinuousScoringMethod continuousScoringMethod;
    @XmlAttribute(name="categoricalScoringMethod")
    @JsonProperty(value="categoricalScoringMethod")
    private CategoricalScoringMethod categoricalScoringMethod;
    @XmlAttribute(name="instanceIdVariable")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="instanceIdVariable")
    private String instanceIdVariable;
    @XmlAttribute(name="threshold")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="threshold")
    private Number threshold;
    @XmlAttribute(name="isScorable")
    @JsonProperty(value="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @JsonProperty(value="x-mathContext")
    @Added(value=Version.XPMML)
    @Since(value="1.3.7")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="TrainingInstances", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="TrainingInstances")
    private TrainingInstances trainingInstances;
    @XmlElement(name="ComparisonMeasure", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="ComparisonMeasure")
    private ComparisonMeasure comparisonMeasure;
    @XmlElement(name="KNNInputs", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="KNNInputs")
    private KNNInputs knnInputs;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Number DEFAULT_THRESHOLD = new RealNumberAdapter().unmarshal("0.001");
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371270L;

    public NearestNeighborModel() {
    }

    @ValueConstructor
    public NearestNeighborModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="numberOfNeighbors") Integer numberOfNeighbors, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="trainingInstances") TrainingInstances trainingInstances, @Property(value="comparisonMeasure") ComparisonMeasure comparisonMeasure, @Property(value="knnInputs") KNNInputs knnInputs) {
        this.miningFunction = miningFunction;
        this.numberOfNeighbors = numberOfNeighbors;
        this.miningSchema = miningSchema;
        this.trainingInstances = trainingInstances;
        this.comparisonMeasure = comparisonMeasure;
        this.knnInputs = knnInputs;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public NearestNeighborModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NEARESTNEIGHBORMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public NearestNeighborModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public NearestNeighborModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer requireNumberOfNeighbors() {
        if (this.numberOfNeighbors == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NEARESTNEIGHBORMODEL_NUMBEROFNEIGHBORS);
        }
        return this.numberOfNeighbors;
    }

    public Integer getNumberOfNeighbors() {
        return this.numberOfNeighbors;
    }

    public NearestNeighborModel setNumberOfNeighbors(@Property(value="numberOfNeighbors") Integer numberOfNeighbors) {
        this.numberOfNeighbors = numberOfNeighbors;
        return this;
    }

    public ContinuousScoringMethod getContinuousScoringMethod() {
        if (this.continuousScoringMethod == null) {
            return ContinuousScoringMethod.AVERAGE;
        }
        return this.continuousScoringMethod;
    }

    public NearestNeighborModel setContinuousScoringMethod(@Property(value="continuousScoringMethod") ContinuousScoringMethod continuousScoringMethod) {
        this.continuousScoringMethod = continuousScoringMethod;
        return this;
    }

    public CategoricalScoringMethod getCategoricalScoringMethod() {
        if (this.categoricalScoringMethod == null) {
            return CategoricalScoringMethod.MAJORITY_VOTE;
        }
        return this.categoricalScoringMethod;
    }

    public NearestNeighborModel setCategoricalScoringMethod(@Property(value="categoricalScoringMethod") CategoricalScoringMethod categoricalScoringMethod) {
        this.categoricalScoringMethod = categoricalScoringMethod;
        return this;
    }

    public String getInstanceIdVariable() {
        return this.instanceIdVariable;
    }

    public NearestNeighborModel setInstanceIdVariable(@Property(value="instanceIdVariable") String instanceIdVariable) {
        this.instanceIdVariable = instanceIdVariable;
        return this;
    }

    public Number getThreshold() {
        if (this.threshold == null) {
            return DEFAULT_THRESHOLD;
        }
        return this.threshold;
    }

    public NearestNeighborModel setThreshold(@Property(value="threshold") Number threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public NearestNeighborModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public NearestNeighborModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NearestNeighborModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.NEARESTNEIGHBORMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public NearestNeighborModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public NearestNeighborModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public NearestNeighborModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public NearestNeighborModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public NearestNeighborModel setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public NearestNeighborModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public TrainingInstances requireTrainingInstances() {
        if (this.trainingInstances == null) {
            throw new MissingElementException(this, PMMLElements.NEARESTNEIGHBORMODEL_TRAININGINSTANCES);
        }
        return this.trainingInstances;
    }

    public TrainingInstances getTrainingInstances() {
        return this.trainingInstances;
    }

    public NearestNeighborModel setTrainingInstances(@Property(value="trainingInstances") TrainingInstances trainingInstances) {
        this.trainingInstances = trainingInstances;
        return this;
    }

    public ComparisonMeasure requireComparisonMeasure() {
        if (this.comparisonMeasure == null) {
            throw new MissingElementException(this, PMMLElements.NEARESTNEIGHBORMODEL_COMPARISONMEASURE);
        }
        return this.comparisonMeasure;
    }

    public ComparisonMeasure getComparisonMeasure() {
        return this.comparisonMeasure;
    }

    public NearestNeighborModel setComparisonMeasure(@Property(value="comparisonMeasure") ComparisonMeasure comparisonMeasure) {
        this.comparisonMeasure = comparisonMeasure;
        return this;
    }

    public KNNInputs requireKNNInputs() {
        if (this.knnInputs == null) {
            throw new MissingElementException(this, PMMLElements.NEARESTNEIGHBORMODEL_KNNINPUTS);
        }
        return this.knnInputs;
    }

    public KNNInputs getKNNInputs() {
        return this.knnInputs;
    }

    public NearestNeighborModel setKNNInputs(@Property(value="knnInputs") KNNInputs knnInputs) {
        this.knnInputs = knnInputs;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public NearestNeighborModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getTrainingInstances(), this.getComparisonMeasure(), this.getKNNInputs(), this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ContinuousScoringMethod implements StringValue<ContinuousScoringMethod>
    {
        MEDIAN("median"),
        AVERAGE("average"),
        WEIGHTED_AVERAGE("weightedAverage");

        private final String value;

        private ContinuousScoringMethod(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static ContinuousScoringMethod fromValue(String v) {
            for (ContinuousScoringMethod c : ContinuousScoringMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum CategoricalScoringMethod implements StringValue<CategoricalScoringMethod>
    {
        MAJORITY_VOTE("majorityVote"),
        WEIGHTED_MAJORITY_VOTE("weightedMajorityVote");

        private final String value;

        private CategoricalScoringMethod(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static CategoricalScoringMethod fromValue(String v) {
            for (CategoricalScoringMethod c : CategoricalScoringMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

