/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jpmml.rexp.AdaConverter;
import org.jpmml.rexp.BaggingConverter;
import org.jpmml.rexp.BinaryTreeConverter;
import org.jpmml.rexp.BoostingConverter;
import org.jpmml.rexp.CaretEnsembleConverter;
import org.jpmml.rexp.Converter;
import org.jpmml.rexp.CrossValGLMNetConverter;
import org.jpmml.rexp.EarthConverter;
import org.jpmml.rexp.ElNetConverter;
import org.jpmml.rexp.ElmNNConverter;
import org.jpmml.rexp.FishNetConverter;
import org.jpmml.rexp.GBMConverter;
import org.jpmml.rexp.GLMConverter;
import org.jpmml.rexp.IForestConverter;
import org.jpmml.rexp.KMeansConverter;
import org.jpmml.rexp.LMConverter;
import org.jpmml.rexp.LRMConverter;
import org.jpmml.rexp.LogNetConverter;
import org.jpmml.rexp.MVRConverter;
import org.jpmml.rexp.MultNetConverter;
import org.jpmml.rexp.MultinomConverter;
import org.jpmml.rexp.NNConverter;
import org.jpmml.rexp.NNetConverter;
import org.jpmml.rexp.NaiveBayesConverter;
import org.jpmml.rexp.OLSConverter;
import org.jpmml.rexp.PartyConverter;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpUtil;
import org.jpmml.rexp.RPartConverter;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RandomForestConverter;
import org.jpmml.rexp.RangerConverter;
import org.jpmml.rexp.SVMConverter;
import org.jpmml.rexp.ScorecardConverter;
import org.jpmml.rexp.TrainConverter;
import org.jpmml.rexp.XGBoostConverter;

public class ConverterFactory {
    private static Map<String, Class<? extends Converter<?>>> converters = new LinkedHashMap();

    protected ConverterFactory() {
    }

    public <R extends RExp> Converter<R> newConverter(R rexp) {
        RStringVector classNames = RExpUtil.getClassNames(rexp);
        for (String className : classNames) {
            Class<? extends Converter<?>> clazz = converters.get(className);
            if (clazz == null) continue;
            return this.newConverter(clazz, rexp);
        }
        throw new IllegalArgumentException("No built-in converter for class " + classNames.getValues());
    }

    public <R extends RExp> Converter<R> newConverter(Class<? extends Converter<?>> clazz, R rexp) {
        try {
            Constructor<Converter<?>> constructor = clazz.getDeclaredConstructor(rexp.getClass());
            return constructor.newInstance(rexp);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ConverterFactory newInstance() {
        return new ConverterFactory();
    }

    static {
        converters.put("ada", AdaConverter.class);
        converters.put("bagging", BaggingConverter.class);
        converters.put("BinaryTree", BinaryTreeConverter.class);
        converters.put("boosting", BoostingConverter.class);
        converters.put("caretEnsemble", CaretEnsembleConverter.class);
        converters.put("cv.glmnet", CrossValGLMNetConverter.class);
        converters.put("earth", EarthConverter.class);
        converters.put("elmNN", ElmNNConverter.class);
        converters.put("elnet", ElNetConverter.class);
        converters.put("fishnet", FishNetConverter.class);
        converters.put("gbm", GBMConverter.class);
        converters.put("iForest", IForestConverter.class);
        converters.put("glm", GLMConverter.class);
        converters.put("kmeans", KMeansConverter.class);
        converters.put("lm", LMConverter.class);
        converters.put("lognet", LogNetConverter.class);
        converters.put("lrm", LRMConverter.class);
        converters.put("multinom", MultinomConverter.class);
        converters.put("multnet", MultNetConverter.class);
        converters.put("mvr", MVRConverter.class);
        converters.put("naiveBayes", NaiveBayesConverter.class);
        converters.put("nn", NNConverter.class);
        converters.put("nnet.formula", NNetConverter.class);
        converters.put("ols", OLSConverter.class);
        converters.put("party", PartyConverter.class);
        converters.put("rpart", RPartConverter.class);
        converters.put("randomForest", RandomForestConverter.class);
        converters.put("ranger", RangerConverter.class);
        converters.put("scorecard", ScorecardConverter.class);
        converters.put("svm", SVMConverter.class);
        converters.put("train", TrainConverter.class);
        converters.put("xgb.Booster", XGBoostConverter.class);
    }
}

