\name{r2lUniv}
\alias{r2lUniv}
\alias{r2lUniv-package}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{~ R to LaTeX Univariate Analyses ~ Overview ~}
\description{
  \code{r2lUniv} performs some basic analyses, then generates a
  code to be included in a LaTeX document to print the analyses in a (so
  nice!) LaTeX way.
  
  \tabular{ll}{
    Package: \tab r2lUniv2\cr
    Type: \tab Package\cr
    Version: \tab 0.4\cr
    Date: \tab 2008-01-01\cr
    License: \tab  GPL (>= 2) \cr
  }
}
\usage{
  r2lUniv(data, fileOutput = "", varName = NA, varNumber = NA, dirGraph = "", graphName = "V", ...)
}

\arguments{
  \item{data}{Either a \code{data.frame} or a \code{vector}}

  \item{fileOutput}{\code{character};
    name of the output file to save
    the \link[=r2lConcepts]{LaTeX summary}. If empty, code is printed on screen.}
 
  \item{varName}{\code{character}, single or vector;
    name of the data.
    If \code{data} is a \code{data.frame}, see \code{\link{r2lUniv.data.frame}}.
    If \code{data} is a \code{vector}, see \code{\link{r2lUniv.r2lBasicClasses}}.}

  %\code{\link[=r2lUniv.ordinal]{ordinal}},
  %\code{\link[=r2lUniv.discrete]{discrete}} or
  %\code{\link[=r2lUniv.continuous]{continuous}}.}
  
  \item{varNumber}{\code{numeric}, single or vector;
    number the \link[=r2lConcepts]{LaTeX summary}.
    If \code{data} is a \code{data.frame}, see \code{\link{r2lUniv.data.frame}}.
    If \code{data} is a \code{vector}, see \code{\link{r2lUniv.r2lBasicClasses}}.}
  
  \item{dirGraph}{\code{character};
    directory used to save the graph generated by the analyses.}

  \item{graphName}{\code{character}, single or vector;
    prefix of the graphs' names.
    If \code{data} is a \code{data.frame}, see \code{\link{r2lUniv.data.frame}}.
    If \code{data} is a \code{vector}, see \code{\link{r2lUniv.r2lBasicClasses}}.}
  
  \item{...}{Can be \code{classModification} (see
    \code{\link{r2lUniv.data.frame}}) or \code{limDiscrete} (see \code{\link{r2lUniv.r2lBasicClasses}}).
  }
}

\details{
  \code{r2lUniv} performs some basic analyses, then generates a
  code to be included in a LaTeX document to print the analyses in a (so
  nice!) LaTeX way.

  \code{r2lUniv} performs the analyses automatically according to the
  \code{data} class. The
  classes defined by \R are not precise enough for \code{r2lUniv}, so it
  is used some other class definition (classical statistics type
  definition) that are \emph{nominal}, \emph{ordinal}, \emph{discrete}
  and \emph{continuous}. This four classes are called
  \link[=r2lConcepts]{r2lUniv basic classes}. For more details, see
  \link{r2lConcepts}.
  
  On these \link[=r2lConcepts]{r2lUniv basic classes}, \code{r2lUniv}
  performs some statistical analyses and
  generates a \link[=r2lConcepts]{LaTeX summary} that can be included in a
  LaTeX document. This summary is built up by methods
  \code{\link[=r2lUniv.r2lBasicClasses]{r2lUniv.nominal}},
  \code{\link[=r2lUniv.r2lBasicClasses]{r2lUniv.ordinal}},
  \code{\link[=r2lUniv.r2lBasicClasses]{r2lUniv.discrete}} and
  \code{\link[=r2lUniv.r2lBasicClasses]{r2lUniv.continuous}}
  
  On the regular \R classes (\code{factor}, \code{logical}, \code{ordered}, \code{integer},
  \code{numeric}), \code{r2lUniv} first changes the class' data to the most adapted
  \link[=r2lConcepts]{r2lUniv basic classes}. Then it runs the corresponding
  method. The function that estimates "the most adapted" class is
  \code{\link{r2lFindClass}}. The methods called by \code{r2lUniv} on \R
  classes are
  \code{\link[=r2lUniv.Rclasses]{r2lUniv.factor}},
  \code{\link[=r2lUniv.Rclasses]{r2lUniv.logical}},
  \code{\link[=r2lUniv.Rclasses]{r2lUniv.ordered}},
  \code{\link[=r2lUniv.Rclasses]{r2lUniv.integer}} and
  \code{\link[=r2lUniv.Rclasses]{r2lUniv.numeric}}
  
  On a \code{data.frame}, \code{r2lUniv} sets the
  \link[=r2lConcepts]{r2lUniv basic classes}
  and runs the analyses on every column.
  More details in \code{\link{r2lUniv.data.frame}}.

  To test this \code{package} quickly, running
  \code{\link{r2lGenerateLatexMain}} will create a compilable LaTeX
  document in which some \link[=r2lConcepts]{LaTeX summary} can be included.
}


\value{
  \code{r2lUniv} generates a LaTeX code and either prints it on screen or saves it in a
  file. It also generates several encapsulated postscript graphs, optionally
  in a different directory.
}

\section{Classical usage}{
  The use of \code{r2lUniv} goes through the following steps:
  \tabular{ll}{
    Step 1. \tab Load the data (usually, a \code{data.frame}).\cr
    Step 2. \tab Optionally, set some variables as \code{ordered}. \cr
    Step 3. \tab Optionally, change the type of some variables (to force some
    \code{discrete} to be \code{continuous}, some \code{logical} to be
    \code{ordered}, ... ; see \link{r2lModifyClasses} for details. \cr
    Step 4. \tab Run \code{r2lUniv(dataFrame,"fileOut.tex")} or
    \code{r2lUniv(dataFrame,"fileOut.tex",classModification=listModif)} if the
    type of some variables must change. \cr
  }
  See examples of \code{\link{r2lUniv.data.frame}} and
  \code{\link{r2lUniv.r2lBasicClasses}} for an application.
}

\section{r2lUniv, in real context...}{
  Bob is working hardly on his Tetris (or on Minesweeper,
  depends). John, his boss, gets in his office:
  \itemize{
    \item Bob, I have some urgent work for you
    \item ...
    \item Bob, I'm talking to you
    \item Huuu ?
    \item I said, I have some urgent work.
    \item Well, John, I am quite busy at the moment.
    \item It is our major client. He's asking for the univariate analyses of his data.
    \item Hey, I am a senior statistician, give that to a rookie!
    \item It is our major client, I want something fast and perfect. You're
    the only one that produce LaTeX reports.
    \item Hmmm. How many variables?
    \item 485.
    \item I need two weeks.
    \item I give you one. I want your report by Friday 11th , 13:00
  }
  Bob pouts, internally smiling, and starts his Tetris again.
  He knows that runnig \code{r2lUniv} on Friday 11th arround 12:30 will
  be soon enouth... As long as John does not know about
  \code{r2lUniv}, life is beautiful.
}

\section{R to LaTeX, Bivariate Analyses}{
  \emph{r2lBiv} (R to LaTeX, Bivariate Analyses) is under construction. Any
  help will be welcomed!
}

\section{Author}{
  Christophe Genolini \cr
  \email{christophe.genolini@free.fr}\cr
  PSIGIAM: Paris Sud Innovation Group in Adolescent Mental Health \cr
  INSERM U669 / Maison de Solenn / Paris
}

\section{English correction}{
  Jean-Marc Chamot \cr
  \email{jchamot@u-paris10.fr}\cr
  Laboratoire "Sport & Culture" / "Sports & Culture" Laboratory \cr
  University of Paris 10 / Nanterre
}


\references{LaTeX web site \url{http://www.latex-project.org/}}


\seealso{\code{\link{Sweave}},
  \code{\link[Hmisc]{latex}},
  \code{\link{r2lConcepts}},
  \code{\link{r2lUniv.data.frame}},
  \code{\link{r2lUniv.r2lBasicClasses}},
  \code{\link{r2lUniv.Rclasses}}
}

\examples{
example(r2lUniv.r2lBasicClasses)
example(r2lUniv.data.frame)
}

\keyword{print}        % Printing
\keyword{package}      % Package summary
\keyword{classes}      % Data type
\keyword{programming}  % Programming
\keyword{interface}    % interface to other languages
\keyword{utilities}    % Utilities
\keyword{univar}       % Simple univariate statistics




