% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frmt.R
\name{frmt}
\alias{frmt}
\alias{frmtp}
\alias{frmtci}
\title{Format Wrappers}
\usage{
frmt(x, digits = getOption("qwraps2_frmt_digits", 2))

frmtp(x, style = getOption("qwraps2_journal", "default"),
  digits = getOption("qwraps2_frmtp_digits", 4),
  markup = getOption("qwraps2_markup", "latex"),
  case = getOption("qwraps2_frmtp_case", "upper"),
  leading0 = getOption("qwraps2_frmtp_leading0", TRUE))

frmtci(x, est = 1, lcl = 2, ucl = 3, format = "est (lcl, ucl)",
  show_level = FALSE, ...)
}
\arguments{
\item{x}{a vector of numbers or a numeric matrix to format.}

\item{digits}{number of digits, including trailing zeros, to the right of the
decimal point.  This option is ignored if \code{is.integer(x) == TRUE)}.}

\item{style}{a character string indicating a specific journal requirements
for p-value formatting.}

\item{markup}{a character string indicating if the output should be latex or
markup.}

\item{case}{a character string indicating if the output should be upper case
or lower case.}

\item{leading0}{boolean, whether or not the p-value should be reported as
0.0123 (TRUE, default), or .0123 (FALSE).}

\item{est}{the numeric index of the vector element or the matrix column
containing the point estimate.}

\item{lcl}{the numeric index of the vector element or the matrix column
containing the lower confidence limit.}

\item{ucl}{the numeric index of the vector element or the matrix column
containing the upper confidence limit.}

\item{format}{a string with "est" "lcl", and "ucl" to denote the location of
the estimate, lower confidence limit, and upper confidence limit for the
formated string.  Defaults to "est (lcl, ucl)".}

\item{show_level}{defualts to FALSE.  If TRUE and \code{format} is the
default, then
"100*(1-options()$qwraps2_alpha)% CI:" will be placed between the left
parenthesis and the lcl.  If set to a string, then the given string will be
placed between the left parenthesis and the lcl.  If the \code{format} is not
the default, then this argument is ignored.}

\item{...}{args passed to frmt}
}
\value{
a character vector of the formatted numbers
}
\description{
Functions for formating numeric values for consistent display
in reports.
}
\details{
`frmt` is really just a wrapper for the \code{formatC}.

`frmtp` formats P-values per journal
requirements.  As I work on papers aimed at different journals, the
formatting functions will be extended to match.

Default settings are controlled through the function arguments but should be
set via \code{options()}.

Default settings report the P-value exactly if P >
\code{getOptions("qwraps2_frmtp_digits", 4)} and reports 
P < \code{10^-(getOptions("qwraps2_frmtp_digits", 2))} otherwise.  By the
leading zero is controlled via 
\code{getOptions("qwraps2_frmtp_leading0", TRUE)} 
and a upper or lower case P is controlled by
\code{getOptions("qwraps2_frmtp_case", "upper")}.  These options are ignored 
if \code{style != "default"}.

Journals with predefined P-value formatting are noted in the
\pkg{\link{qwraps2}} documentation.

`frmtci` takes a \code{matrix}, or \code{data.frame}, with a point estimate
and the lcl and ucl and formats a string for reporting.  est (lcl, ucl) is
the default.  The confidence level can be added to the string, e.g., "est
(95% CI: lcl, ucl)" with \code{show_level = TRUE} or by setting your own
format.

`frmtcip` expects four values, est, lcl, ucl, and p-value.  The resulting
sting will be of the form "est (lcl, ucl; p-value)".

The `Rpkg`, `CRANpkg`, and `Githubpkg` functions are used to help make
documenting packages stylistically consistent and with valid urls.  These
functions were inspired by similar ones found in BioConductor's BiocStyle
package.
}
\examples{

# Formatting numbers
integers <- c(1234L, 9861230L)
numbers  <- c(1234,  9861230)
frmt(integers)  # no decimal point
frmt(numbers)   # decimal point and zeros to the right

numbers <- c(0.1234, 0.1, 1234.4321, 0.365, 0.375)
frmt(numbers)

# Formatting p-values
ps <- c(0.2, 0.001, 0.00092, 0.047, 0.034781, 0.0000872, 0.787, 0.05, 0.043)
# LaTeX is the default markup language
cbind("raw"      = ps, 
      "default"  = frmtp(ps), 
      "3lower"   = frmtp(ps, digits = 3, case = "lower"),
      "PediDent" = frmtp(ps, style = "pediatric_dentistry"))

# Using markdown
cbind("raw"      = ps, 
      "default"  = frmtp(ps, markup = "markdown"), 
      "3lower"   = frmtp(ps, digits = 3, case = "lower", markup = "markdown"),
      "PediDent" = frmtp(ps, style = "pediatric_dentistry", markup = "markdown"))

# Formatting the point estimate and confidence interval
# for a set of three values
temp <- c(a = 1.23, b = .32, CC = 1.78)
frmtci(temp) 
frmtci(temp, show_level = TRUE) 

# note that the show_level will be ignored in the following
frmtci(temp, format = "est ***lcl, ucl***", show_level = TRUE)

# show_level as a character
frmtci(temp, show_level = "confidence between: ")

# For a matrix: the numbers in this example don't mean anything, but the
# formatting should.
temp2 <- matrix(rnorm(12), nrow = 4, 
                dimnames = list(c("A", "B", "C", "D"), c("EST", "LOW", "HIGH")))
temp2
frmtci(temp2)
}
\seealso{
\code{\link{formatC}}
}
