% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.interaction.R
\name{plot.interaction}
\alias{plot.interaction}
\title{Plot Interaction Differences}
\usage{
\method{plot}{interaction}(x, type = "all", ...)
}
\arguments{
\item{x}{An interaction object containing the differences to be plotted.
This object should include fields for CD4 differences (raw and standardized)
and viral load differences (raw, log10-transformed, and log10-standardized).}

\item{type}{A character string indicating the type of plot to generate.
Options include: "cd_diff", "cds_diff", "vl_diff", "vlog_diff", "vlogs_diff",
or "all" (the default) to plot all types of differences.}

\item{...}{Additional arguments passed to the plot function.}
}
\value{
Plots histograms and QQ plots for the specified differences. If
\code{type} is "all", all plots are arranged in a grid layout.
}
\description{
This function generates histograms and QQ plots for the differences in CD4
and viral load values contained in an interaction object. Users can choose to
plot all differences or specify which type to plot.
}
\examples{
\donttest{
data("vl_3")
data("cd_3")
interaction_obj <- create_interactions(cd_3, vl_3)
plot(interaction_obj, type = "cd_diff")    
}
}
