#' Prints an Example of a QualtRics Configuration File to the Console.
#'
#' This function is deprecated; use \code{\link[qualtRics]{qualtrics_api_credentials}} instead.
#'
#' @param api_token String. API token. Available in your qualtrics account (see: \url{https://api.qualtrics.com/docs/authentication})
#' @param base_url String. Base url for your institution (see: \url{https://api.qualtrics.com/docs/root-url})
#' @param verbose Logical. If TRUE, verbose messages will be printed to the R console. Defaults to TRUE.
#' @param useLabels Logical. TRUE to export survey responses as Choice Text or FALSE to export survey responses as values.
#' @param convertVariables Logical. If TRUE, then the \code{\link[qualtRics]{getSurvey}} function will convert certain question types (e.g. multiple choice) to proper data type in R. Defaults to TRUE.
#' @param useLocalTime Logical. Use local timezone to determine response date values? Defaults to FALSE. See \url{https://api.qualtrics.com/docs/dates-and-times} for more information.
#' @param dateWarning Logical. Once per session, qualtRics will emit a warning about date conversion for surveys. You can turn this warning off by changing the flag to FALSE. Defaults to TRUE.
#' @param root_url String. Deprecated. Use `base_url` instead. This will be removed in future versions.
#' @seealso See \url{https://api.qualtrics.com/docs/root-url} for documentation on the Qualtrics API. See \url{https://github.com/ropensci/qualtRics/blob/master/README.md#using-a-configuration-file} for more information about the qualtRics configuration file.
#' @export
#' @examples
#' \dontrun{
#' # Execute this line to get instructions on how to make a .qualtrics.yml config file.
#' qualtRicsConfigFile()
#' }
#'
qualtRicsConfigFile <- function(api_token = NULL,
                                base_url = NULL,
                                verbose = TRUE,
                                useLabels = TRUE,
                                convertVariables = TRUE,
                                useLocalTime = FALSE,
                                dateWarning = TRUE,
                                root_url = NULL) {

  .Deprecated("`qualtRicsConfigFile` is deprecated. Use `qualtrics_api_credentials()` instead.")

  # Check for deprecated arguments
  calls <- names(vapply(match.call(), deparse, "character"))[-1]
  # Check if deprecated params passed
  if (any("root_url" %in% calls)) {
    warning("'root_url' is deprecated and will be removed in qualtRics 4.0.\n Please use 'base_url' instead.")
    base_url <- root_url
  }
  # Temporary
  root_url <- base_url

  # Paste together a message to cat to console
  msg <- paste0(
    "Copy-paste the lines between the dashes into a new plain text file, replace the
values for the api_token and root_url if they are not yet filled out. and save it in
your working directory as '.qualtRics.yml'. Execute '?qualtRics::qualtRicsConfigFile'
to view an explanation of the additional arguments. Visit
https://github.com/ropensci/qualtRics/blob/master/README.md#using-a-configuration-file
for more information.", "\n\n", # nolint
    "--------------", "\n",
    "api_token: ", ifelse(is.null(api_token), "<YOUR-API-TOKEN-HERE>",
      paste0(api_token)
    ), "\n",
    "base_url: ", ifelse(is.null(root_url), "<YOUR-ROOT-URL-HERE>",
      paste0(root_url)
    ), "\n",
    "verbose: ", verbose, "\n",
    "uselabels: ", useLabels, "\n",
    "convertvariables: ", convertVariables, "\n",
    "uselocaltime: ", useLocalTime, "\n",
    "datewarning: ", dateWarning, "\n",
    "--------------"
  )

  # Cat to console
  cat(msg)
}

#' Retrieve a data frame containing question IDs and labels
#'
#' This function is deprecated; use \code{\link[qualtRics]{survey_questions}}
#' instead.
#' @param ... All arguments for \code{survey_questions}
#'
#' @export
getSurveyQuestions <- function(...) {
  .Deprecated("`getSurveyQuestions` is deprecated. Try using `survey_questions()` instead.")
  survey_questions(...)
}

#' Download a survey and import it into R
#'
#' This function is deprecated; use \code{\link[qualtRics]{fetch_survey}}
#' instead.
#' @param ... All arguments for \code{fetch_survey}
#'
#' @export
getSurvey <- function(...) {
  .Deprecated("`getSurvey` is deprecated. Try using `fetch_survey()` instead.")
  fetch_survey(...)
}

#' Read a CSV file exported from Qualtrics
#'
#' This function is deprecated; use \code{\link[qualtRics]{read_survey}}
#' instead.
#' Reads comma separated CSV files generated by Qualtrics
#' software. The second line containing the variable labels is imported.
#' Repetitive introductions to matrix questions are automatically removed.
#' Variable labels are stored as attributes.
#' @param ... All arguments for \code{\link[qualtRics]{read_survey}}
#'
#' @export
readSurvey <- function(...) {
  .Deprecated("`readSurvey` is deprecated. Try using `read_survey()` instead.")
  read_survey(...)
}





