% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalExp2ddCt.R
\name{CalExp2ddCt}
\alias{CalExp2ddCt}
\title{Calculate expression using standard curve.}
\arguments{
\item{cq.table}{The data frame of the position and cq value.}

\item{design.table}{The data frame of the position and corresponding information.}

\item{correction}{Correct expression value by reference gene.}

\item{ref.gene}{The name of reference gene.}

\item{ref.group}{The name of reference group.}

\item{stat.method}{Statistical method.}

\item{fig.type}{Calculation by mean cq value or not.}

\item{fig.ncol}{Number of columes of figure.}
}
\value{
A list contain a table and a figure.
}
\description{
Calculate expression using standard curve.
}
\examples{
df1.path = system.file("examples", "ddct.cq.txt", package = "qPCRtools")
df2.path = system.file("examples", "ddct.design.txt", package = "qPCRtools")

cq.table = data.table::fread(df1.path)
design.table = data.table::fread(df2.path)

CalExp2ddCt(cq.table,
            design.table,
            ref.gene = "OsUBQ",
            ref.group = "CK",
            stat.method = "t.test",
            fig.type = "box",
            fig.ncol = NULL) -> res

res[["table"]]
res[["figure"]]

}
\author{
Xiang LI <lixiang117423@gmail.com>
}
