/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule;

import eu.kliegr.ac1.data.Attribute;
import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.data.Transaction;
import eu.kliegr.ac1.performance.StopWatches;
import eu.kliegr.ac1.rule.Data;
import eu.kliegr.ac1.rule.Prediction;
import eu.kliegr.ac1.rule.Rule;
import eu.kliegr.ac1.rule.RuleMultiItem;
import eu.kliegr.ac1.rule.TestRule;
import eu.kliegr.ac1.rule.TestingType;
import eu.kliegr.ac1.rule.extend.Distribution;
import eu.kliegr.ac1.rule.extend.DistributionFactory;
import eu.kliegr.ac1.rule.extend.TestRuleAnnotation;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class TestRules {
    private static final Logger LOGGER = Logger.getLogger(TestRules.class.getName());
    private ArrayList<TestRule> rules = new ArrayList();
    private ConcurrentSkipListMap<Transaction, Prediction[]> allCovered;
    private int totalCorrect;
    private int totalIncorrect;
    private int oneRuleClassifications;
    private int mixtureClassifications;
    private int uncovered;
    private final Comparator ruleComparator;
    private final Data rmi;

    public TestRules(ArrayList<Rule> rules, Comparator ruleComparator, Data rmi) {
        this.ruleComparator = ruleComparator;
        this.rules = rules.stream().map(rule -> new TestRule((Rule)rule)).collect(Collectors.toCollection(ArrayList::new));
        this.rmi = rmi;
    }

    public ArrayList<TestRule> getRules() {
        return this.rules;
    }

    public void sortRules() {
        this.rules.sort(this.ruleComparator);
    }

    public void classifyData(TestingType type) {
        LOGGER.log(Level.INFO, "Number of rules {0}", this.rules.size());
        switch (type) {
            case mixture: {
                this.classifyDataMixture(1);
                break;
            }
            case firstMatch: {
                this.classifyDataFirstMatch();
                break;
            }
            default: {
                throw new UnsupportedOperationException("This testing type is not supported");
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.info("\n\n#internal TID, TID, prediction, trust (!!missing are skipped !!)\n");
            this.allCovered.entrySet().stream().forEach(t -> {
                for (Prediction p : (Prediction[])t.getValue()) {
                    LOGGER.log(Level.INFO, "{0},{1},{2},{3},{4}", new Object[]{((Transaction)t.getKey()).getInternalTID(), ((Transaction)t.getKey()).getExternalTID(), t.toString(), p.consequent, Float.valueOf(p.trust)});
                }
            });
        }
        LOGGER.log(Level.INFO, "\n\nTotal correct {0}", this.totalCorrect);
        LOGGER.log(Level.INFO, "Total incorrect {0}", this.totalIncorrect);
    }

    public void classifyDataFirstMatch() {
        this.allCovered = new ConcurrentSkipListMap();
        LOGGER.info("#Begin classify\n");
        this.totalCorrect = 0;
        this.totalIncorrect = 0;
        this.rules.stream().map(rule -> {
            LOGGER.log(Level.INFO, "#{0}\n", rule);
            return rule;
        }).forEach(rule -> {
            Set<Transaction> covered = rule.fireRuleAgainstData(true, this.rmi);
            LOGGER.log(Level.INFO, "test conf={0}\n", Float.valueOf(rule.testQuality.getConfidence()));
            LOGGER.log(Level.INFO, "true positives: {0}, false positives: {1}\n", new Object[]{rule.testQuality.a, rule.testQuality.b});
            this.totalCorrect += rule.testQuality.a.intValue();
            this.totalIncorrect += rule.testQuality.b.intValue();
            covered.stream().map(t -> {
                t.setCoveringRule((TestRule)rule);
                return t;
            }).forEach(t -> this.allCovered.put((Transaction)t, new Prediction[]{new Prediction(rule.getConsequent(), rule.getConfidence())}));
        });
    }

    private HashMap<Transaction, ArrayList<TestRule>> createIndexTransRule() {
        HashMap<Transaction, ArrayList<TestRule>> transWmatchingRules = new HashMap<Transaction, ArrayList<TestRule>>();
        this.rules.stream().map(rule -> {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "#{0}\n", rule);
            }
            return rule;
        }).forEach(rule -> {
            Set<Transaction> covered = rule.fireRuleAgainstData(false, this.rmi);
            covered.stream().forEach(trans -> {
                ArrayList<TestRule> exRules = (ArrayList<TestRule>)transWmatchingRules.get(trans);
                if (exRules == null) {
                    exRules = new ArrayList<TestRule>();
                    transWmatchingRules.put((Transaction)trans, exRules);
                }
                exRules.add((TestRule)rule);
            });
        });
        return transWmatchingRules;
    }

    public HashMap<Attribute, ArrayList<Distribution>> getDistributionsByAttribute(ArrayList<TestRule> curRules, Transaction t, DistributionFactory distrFactory) {
        HashMap<Attribute, ArrayList<Distribution>> distributionsByAttribute = new HashMap<Attribute, ArrayList<Distribution>>();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Rules to obtain distributions from: {0}", curRules.size());
        }
        for (TestRule r : curRules) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Obtaining distributions from rule {0}", r);
                LOGGER.log(Level.FINE, "This rule has {0} multiitems. ", r.getAntecedent().getItems().size());
            }
            for (RuleMultiItem rmi : r.getAntecedent().getItems()) {
                Attribute curAt = rmi.getAttribute();
                AttributeValue tVal = t.getValue(curAt);
                Distribution distr = ((TestRuleAnnotation)r.getAnnotation()).getDistributionForValue(tVal, distrFactory);
                if (distr == null) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "No value with distribution found for {0}", tVal.toString(true, true));
                    continue;
                }
                distr.setWeight(Float.valueOf(r.getSupport()));
                ArrayList<Distribution> allDistrForAtt = distributionsByAttribute.get(curAt);
                if (allDistrForAtt == null) {
                    allDistrForAtt = new ArrayList();
                    distributionsByAttribute.put(curAt, allDistrForAtt);
                }
                allDistrForAtt.add(distr);
            }
        }
        return distributionsByAttribute;
    }

    public void classifyDataMixture(int predictionsPerTransaction) {
        this.oneRuleClassifications = 0;
        this.mixtureClassifications = 0;
        HashMap<Transaction, ArrayList<TestRule>> transWmatchingRules = this.createIndexTransRule();
        this.allCovered = new ConcurrentSkipListMap();
        LOGGER.info("#Begin classify\n");
        this.totalCorrect = 0;
        this.totalIncorrect = 0;
        for (Map.Entry<Transaction, ArrayList<TestRule>> entry : transWmatchingRules.entrySet()) {
            HashMap<Attribute, ArrayList<Distribution>> distributionsByAttribute;
            Transaction t = entry.getKey();
            ArrayList curRules = entry.getValue();
            Prediction[] prediction = null;
            Distribution finalDistr = null;
            DistributionFactory distrFactory = new DistributionFactory();
            if (curRules.size() > 1) {
                ArrayList nonFuzzyMatch;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "There are {0} rules matching transaction {1}\n", new Object[]{curRules.size(), t});
                }
                if ((nonFuzzyMatch = curRules.stream().filter(rule -> !rule.isMatchesInFuzzyBorder(t)).collect(Collectors.toCollection(ArrayList::new))).size() > 0 && nonFuzzyMatch.size() != curRules.size()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Not using rules with fuzzy matching regions: {0} rules remaining from {1}", new Object[]{nonFuzzyMatch.size(), curRules.size()});
                    }
                    curRules = nonFuzzyMatch;
                }
                if (curRules.size() > 1) {
                    distributionsByAttribute = this.getDistributionsByAttribute(curRules, t, distrFactory);
                    finalDistr = distrFactory.aggregateDistributions(distributionsByAttribute);
                    if (finalDistr == null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("No distribution found, defaulting to classification by most confident rule");
                        }
                    } else {
                        Prediction[] debug = distrFactory.getMax(finalDistr, 1);
                        prediction = distrFactory.getMax(finalDistr, predictionsPerTransaction);
                        if (prediction[0] == null) {
                            LOGGER.warning("NULL");
                            prediction = distrFactory.getMax(finalDistr, predictionsPerTransaction);
                        }
                        if (debug[0].consequent != prediction[0].consequent) {
                            LOGGER.warning("Unmatching best predictions");
                        }
                    }
                }
            }
            if (curRules.size() == 1 || prediction == null) {
                if (LOGGER.isLoggable(Level.FINE) && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "There is only one rule matching transaction {0}", t);
                }
                ++this.oneRuleClassifications;
                TestRule r = curRules.get(0);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(r.toString());
                }
                t.setCoveringRule(r);
                if (predictionsPerTransaction > 1) {
                    distributionsByAttribute = this.getDistributionsByAttribute(curRules, t, distrFactory);
                    finalDistr = distrFactory.aggregateDistributions(distributionsByAttribute);
                    if (finalDistr == null) {
                        throw new UnsupportedOperationException("prediction=distributionOfTargetAttributeInTrainingData");
                    }
                    prediction = distrFactory.getMax(finalDistr, predictionsPerTransaction);
                    if (prediction[0].consequent != r.getConsequent()) {
                        LOGGER.log(Level.WARNING, "WARNING, multiclass required: prediction outcome different from the mixture outcome. Using mixture outcome. Transaction:{0}", t);
                    }
                } else {
                    prediction = new Prediction[]{new Prediction(r.getConsequent(), r.getConfidence())};
                }
            }
            AttributeValue actual = t.getTarget();
            if (predictionsPerTransaction == 0) {
                // empty if block
            }
            if (prediction[0].consequent.getItems().getAttributeValues().contains(actual)) {
                ++this.totalCorrect;
            } else {
                ++this.totalIncorrect;
            }
            this.allCovered.put(t, prediction);
        }
    }

    public String[] getResult() {
        if (this.allCovered.isEmpty()) {
            return null;
        }
        int lastTransactionID = this.allCovered.firstEntry().getKey().getFirstTID();
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Transaction, Prediction[]> t : this.allCovered.entrySet()) {
            Transaction curT = t.getKey();
            int curTID = curT.getInternalTID();
            int delta = curTID - lastTransactionID;
            for (int i = 1; i < delta; ++i) {
                result.add(null);
            }
            TestRule coveringRule = t.getKey().getCoveringRule();
            for (Prediction p : t.getValue()) {
                result.add(p.consequent.toString(true, false));
            }
            lastTransactionID = curTID;
        }
        return result.toArray(new String[result.size()]);
    }

    public void saveDebugResult(String path) throws FileNotFoundException, IOException {
        File dir = new File(new File(path).getParent());
        dir.mkdir();
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path));
        Attribute IDattribute = this.rmi.getDataTable().getIDAttribute();
        String idname = "";
        if (IDattribute != null) {
            idname = IDattribute.getName();
        }
        ((OutputStream)output).write(("internal TID,prediction," + idname + ", covering rule, trust \n").getBytes());
        if (!this.allCovered.isEmpty()) {
            int lastTransactionID = this.allCovered.firstEntry().getKey().getFirstTID();
            for (Map.Entry<Transaction, Prediction[]> t : this.allCovered.entrySet()) {
                Transaction curT = t.getKey();
                int curTID = curT.getInternalTID();
                int delta = curTID - lastTransactionID;
                for (int i = 1; i < delta; ++i) {
                    ((OutputStream)output).write((lastTransactionID + i + ",,,\n").getBytes());
                }
                TestRule coveringRule = t.getKey().getCoveringRule();
                String ruleText = coveringRule == null ? "rule mixture" : String.join((CharSequence)"", "\"", coveringRule.toString(), "\"");
                for (Prediction p : t.getValue()) {
                    ((OutputStream)output).write((t.getKey().getInternalTID() + "," + p.consequent.toString(true, false) + "," + t.getKey().getExternalTID() + "," + ruleText + "," + p.trust + "\n").getBytes());
                }
                lastTransactionID = curTID;
            }
        }
        ((OutputStream)output).flush();
        ((OutputStream)output).close();
    }

    public void saveSummary(String path, int totalTransactions, StopWatches watches) throws FileNotFoundException, IOException {
        File dir = new File(new File(path).getParent());
        dir.mkdir();
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path));
        ((OutputStream)output).write(("Number of rules:" + this.rules.size()).getBytes());
        ((OutputStream)output).write("\n".getBytes());
        ((OutputStream)output).write(("Number of test instances:" + totalTransactions).getBytes());
        ((OutputStream)output).write("\n".getBytes());
        ((OutputStream)output).write(("True positives:" + this.totalCorrect).getBytes());
        ((OutputStream)output).write("\n".getBytes());
        ((OutputStream)output).write(("False positives:" + this.totalIncorrect).getBytes());
        ((OutputStream)output).write("\n".getBytes());
        ((OutputStream)output).write(("Uncovered:" + (totalTransactions - this.totalCorrect - this.totalIncorrect)).getBytes());
        ((OutputStream)output).write("\n".getBytes());
        ((OutputStream)output).write(("Accuracy (excl. unclassified):" + (double)this.totalCorrect / (double)(this.totalCorrect + this.totalIncorrect)).getBytes());
        ((OutputStream)output).write("\n".getBytes());
        ((OutputStream)output).write(("Accuracy:" + (double)this.totalCorrect / (double)totalTransactions).getBytes());
        ((OutputStream)output).write("\n".getBytes());
        ((OutputStream)output).write(watches.toString().getBytes());
        ((OutputStream)output).flush();
        ((OutputStream)output).close();
    }
}

