% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApproveAssignment.R
\name{ApproveAssignment}
\alias{ApproveAssignment}
\alias{ApproveAssignments}
\alias{approve}
\alias{ApproveAllAssignments}
\alias{approveall}
\title{Approve Assignment(s)}
\usage{
ApproveAssignment(assignments, feedback = NULL, rejected = FALSE,
  verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{assignments}{A character string containing an AssignmentId, or a
vector of multiple character strings containing multiple AssignmentIds, to
approve.}

\item{feedback}{An optional character string containing any feedback for a
worker. This must have length 1 or length equal to the number of workers.
Maximum of 1024 characters.}

\item{rejected}{A logical indicating whether the assignment(s) had
previously been rejected (default \code{FALSE}), or a vector of logicals.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the list of AssignmentIds, feedback (if
any), whether previous rejections were to be overriden,
and whether or not each approval request was valid.
}
\description{
Approve one or more submitted assignments, or approve all assignments for a
given HIT or HITType. Also allows you to approve a previously rejected
assignment. This function spends money from your MTurk account.
}
\details{
Approve assignments, by AssignmentId (as returned by
\code{\link{GetAssignment}} or by HITId or HITTypeId. Must specify
\code{assignments}. \code{ApproveAllAssignments} approves all assignments of a given HIT or
HITType without first having to perform \code{\link{GetAssignment}}.

\code{ApproveAssignments()} and \code{approve()} are aliases for \code{ApproveAssignment}.
\code{approveall()} is an alias for \code{ApproveAllAssignments}.
}
\examples{

\dontrun{
# Approve one assignment
ApproveAssignment(assignments = "26XXH0JPPSI23H54YVG7BKLEXAMPLE")

# Approve multiple assignments with the same feedback
ApproveAssignment(assignments = c("26XXH0JPPSI23H54YVG7BKLEXAMPLE1",
                                  "26XXH0JPPSI23H54YVG7BKLEXAMPLE2"),
                  feedback = "Great work!")
}

}
\references{
\href{http://docs.amazonwebservices.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html}{API
Reference: Approve Assignment}

\href{http://docs.amazonwebservices.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveRejectedAssignmentOperation.html}{API
Reference: Approve Rejected Assignment}
}
\seealso{
\code{\link{RejectAssignment}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Assignments}
