\name{Generic t Test}
\alias{power.t.test}

\title{Statistical Power for the Generic t Test with (optional) Type I and Type II Error Plots}

\description{
Calculates statistical power for the generic t test with (optional) Type I and Type II error plots.
Unlike other more specific functions \code{power.t.test()} function allows specification of multiple values for one parameter at a time (only when \code{plot = FALSE}).
}

\usage{
power.t.test(ncp, df, alpha = 0.05,
             alternative = c("not equal", "greater", "less",
                             "non-inferior", "superior", "equivalent"),
             plot = TRUE, plot.main = NULL, plot.sub = NULL,
             verbose = TRUE)
}

\arguments{
  \item{ncp}{non-centrality parameter (lambda)}
  \item{df}{degrees of freedom for the t test}
  \item{alpha}{probability of type I error}
  \item{alternative}{direction or type of the hypothesis test: "not equal", "greater", "less", "equivalent", "non-inferior", or "superior". This information is needed only for power calculation}
  \item{plot}{if \code{TRUE} plots Type I and Type II error plots}
  \item{plot.main}{plot title}
  \item{plot.sub}{plot subtitle}
  \item{verbose}{if \code{FALSE} no output is printed on the console. Useful for simulation, plotting, and whatnot}
}

\value{
  \item{power}{statistical power \eqn{(1-\beta)}}
}

\examples{
# power is defined as the probability of observing t-statistics
# greater than the positive critical t value OR
# less than the negative critical t value
power.t.test(ncp = 1.96, df = 99, alpha = 0.05,
             alternative = "not equal")

# power is defined as the probability of observing t-statistics
# greater than the critical t value
power.t.test(ncp = 1.96, df = 99, alpha = 0.05,
             alternative = "greater")

# power is defined as the probability of observing t-statistics
# greater than the critical t value where the non-centrality parameter
# for the alternative distribution is adjusted for the non-inferiority margin
power.t.test(ncp = 1.98, df = 99, alpha = 0.05,
             alternative = "non-inferior")

# power is defined as the probability of observing t-statistics
# greater than the critical t value where the non-centrality parameter
# for the alternative distribution is adjusted for the superiority margin
power.t.test(ncp = 1.94, df = 99, alpha = 0.05,
             alternative = "superior")

# power is defined as the probability of observing t-statistics
# less than the positive critical t value AND
# greater than the negative critical t value
# the non-centrality parameter is for the null distribution
# and is derived from the equivalence margins (lower and upper)
power.t.test(ncp = 1.96, df = 999, alpha = 0.05,
             alternative = "equivalent")
# or, define lower and upper bound with rbind()
power.t.test(ncp = rbind(-1.96,1.96),
             df = 999, alpha = 0.05,
             alternative = "equivalent")
}
