% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makespaghetti.R
\name{make.spaghetti}
\alias{make.spaghetti}
\title{Generate a spaghetti plot to visualize longitudinal data}
\usage{
make.spaghetti(
  x,
  y,
  id,
  group = NULL,
  data,
  col = NULL,
  pch = 16,
  lty = 1,
  lwd = 1,
  title = "",
  xlab = NA,
  ylab = NA,
  legend.title = "",
  cex.axis = 1,
  cex.title = 1,
  cex.lab = 1,
  cex.leg = 1,
  legend.inset = -0.3
)
}
\arguments{
\item{x}{the time variable (numeric vector)}

\item{y}{the longitudinal outcome (numeric vector)}

\item{id}{the subject indicator}

\item{group}{the group that each subject belongs to (optional, 
do not specify if not relevant)}

\item{data}{a data frame containing x, y, id and optionally group}

\item{col}{a vector of colors (optional)}

\item{pch}{dot type}

\item{lty}{line type}

\item{lwd}{line width}

\item{title}{plot title}

\item{xlab}{label for the x axis}

\item{ylab}{label for the y axis}

\item{legend.title}{legend title}

\item{cex.axis}{font size for the axes}

\item{cex.title}{title font size}

\item{cex.lab}{font size for axis labels}

\item{cex.leg}{font size for the legend}

\item{legend.inset}{moves legend more to the left / right}
}
\description{
A spaghetti plot, or trajectory plot, is a plot that allows
to compare across individuals or groups the trajectories 
of a longitudinal outcome
}
\examples{
\donttest{
# generate example data
set.seed(123)
n = 12; t = 6
id = rep(1:n, each = t)
rand.int = rep(rnorm(n, sd = 0.5), each = t)
group = rep(c(0,1), each = n*t/2)
time = rep(0:(t-1), n)
offset = rnorm(n*t, sd = 0.3)
beta = c(3, 0, 0.1, 0.3)
X = model.matrix(~group + time + group*time)
mu = 2^(X \%*\% beta + rand.int + offset)
y = rpois(n*t, lambda = mu)
group = ifelse(group == 0, 'control', 'treatment')
data.long = data.frame(y, group, time, id, offset)
rm(list = setdiff(ls(), 'data.long'))

# create plot
make.spaghetti(x = time, y, id, group, 
data = data.long, title = 'spaghetti plot')
}
}
\author{
Mirko Signorelli
}
