% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptmScan.R
\name{ac.scan}
\alias{ac.scan}
\title{Scan a Protein in Search of Acetylation Sites}
\usage{
ac.scan(up_id, db = 'all')
}
\arguments{
\item{up_id}{a character string corresponding to the UniProt ID.}

\item{db}{the database where to search. It should be one among 'PSP', 'dbPTM', 'all'.}
}
\value{
Returns a dataframe where each row corresponds to an acetylable residue.
}
\description{
Scans the indicated protein in search of acetylation sites.
}
\details{
If db = 'all' has been selected, it may happen that the same residue appears in several rows if it is present in different databases.
}
\examples{
\dontrun{ac.scan('P01009', db = 'PSP')}
}
\references{
Hornbeck et al. Nucleic Acids Res. 2019 47:D433-D441, (PMID: 30445427).

Huang et al. Nucleic Acids Res. 2019 47:D298-D308, (PMID: 30418626).
}
\seealso{
meto.scan(), p.scan(), me.scan(), ub.scan(), su.scan(), gl.scan(), sni.scan(), ni.scan(), ptm.scan(), reg.scan(), dis.scan()
}
\author{
Juan Carlos Aledo
}
