% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangle_data.R
\name{organize_database}
\alias{organize_database}
\title{Organize a database of multi-construct or moderated information}
\usage{
organize_database(es_data, sample_id = NULL, citekey = NULL,
  construct_x = NULL, construct_y = NULL, facet_x = NULL,
  facet_y = NULL, measure_x = NULL, measure_y = NULL, data_x = NULL,
  data_y = NULL, moderators = NULL, use_as_x = NULL, use_as_y = NULL,
  construct_order = NULL, cat_moderators = TRUE, moderator_levels = NULL)
}
\arguments{
\item{es_data}{Matrix of effect-size data to be used in meta-analyses.}

\item{sample_id}{Optional vector of identification labels for studies in the meta-analysis.}

\item{citekey}{Optional vector of bibliographic citation keys for samples/studies in the meta-analysis (if multiple citekeys pertain to a given effect size, combine them into a single string entry with comma delimiters (e.g., "citkey1,citekey2").}

\item{construct_x}{Vector of construct names for construct initially designated as X.}

\item{construct_y}{Vector of construct names for construct initially designated as Y.}

\item{facet_x}{Vector of facet names for construct initially designated as X.}

\item{facet_y}{Vector of facet names for construct initially designated as Y.}

\item{data_x}{Additional data (e.g., artifact information) specific to the variables originally designated as X.}

\item{data_y}{Additional data (e.g., artifact information) specific to the variables originally designated as Y.}

\item{moderators}{Matrix, dataframe, or vector of moderators.}

\item{use_as_x}{Vector of construct names to be categorized as X constructs - cannot overlap with the contents of 'use_as_y'.}

\item{use_as_y}{Vector of construct names to be categorized as Y constructs - cannot overlap with the contents of 'use_as_x'.}

\item{construct_order}{Vector indicating the order in which variables should be arranged, with variables listed earlier in the vector being preferred for designation as X.}

\item{cat_moderators}{Logical vector identifying whether each variable in moderators is a categorical variable (TRUE) or a continuous variable (FALSE).}

\item{moderator_levels}{Optional list of factor levels to be applied to the categorical moderators.}
}
\value{
A reorganized list of study data
}
\description{
Organize a database of multi-construct or moderated information
}
\keyword{internal}
