"lavaan.diagram" <- 
function(fit,title,...) {
if (is.null(fit@Model@GLIST$beta)) {model <- "cfa"} else {model <- "sem"}
if(missing(title)) {if(model =="cfa") { title="Confirmatory structure" } else {title = "Structural model"}
                       }
        mimic <- fit@Model@fixed.x
       if(!mimic) { fx=fit@Model@GLIST$lambda
       # colnames(fx) <- fit@Model@dimNames$lambda[[2]]
       colnames(fx) <- fit@Model@dimNames[[1]][[2]]
       rownames(fx) <- fit@Model@dimNames[[1]][[1]]
         Phi <-  fit@Model@GLIST$psi
                  Rx <- fit@Model@GLIST$theta
                  v.labels <-fit@Model@dimNames[[1]][[1]]
        } else { #mimic
        y.vars <- fit@Model@x.user.idx[[1]]

        nx  <- fit@Model@ov.x.dummy.lv.idx[[1]]
        fy <- fit@Model@GLIST$lambda[y.vars,-nx]
        fx <- fit@Model@GLIST$beta[-nx,nx]
        colnames(fy) <- fit@Model@dimNames[[1]][[2]][-nx]
       rownames(fy) <- fit@Model@dimNames[[1]][[1]][y.vars]
        
        }
  if(model=="cfa") {                
structure.diagram(fx=fx,Phi=Phi,Rx=Rx,labels=v.labels,main=title,e.size=.1,...)}
else {structure.diagram(fx=fx,Phi=(fit@Model@GLIST$beta),Rx=Rx,labels=v.labels,main=title,e.size=.1,...) }
}
#modified 11/6/14 to draw the regression paths


#created August 17, 2017 to allow sem.diagrams and graphs from sem output 
"sem.diagram" <- function(fit,main="A SEM from the sem package",...) {
  nvar <- ncol(fit$S)
  var.names <- fit$var.names
  tot.var <- ncol(fit$A)
  num.factors <- length(var.names) - nvar
  fx <- fit$A[1:nvar,(nvar+1):ncol(fit$A)]
  Phi <- fit$P[(nvar+1):tot.var,(nvar+1):tot.var]
 structure.diagram(fx,Phi,main=main,...)
 }
 

"sem.graph" <- function(fit,out.file=NULL,main="A SEM from the sem package",...) {
  nvar <- ncol(fit$S)
  var.names <- fit$var.names
  tot.var <- ncol(fit$A)
  num.factors <- length(var.names) - nvar
  fx <- fit$A[1:nvar,(nvar+1):ncol(fit$A)]
  Phi <- fit$P[(nvar+1):tot.var,(nvar+1):tot.var]
 structure.graph(fx,Phi,out.file=out.file,title=main,...)
 }
  