% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_spectral_density.R
\name{PSDIntegrationPerFreqBin}
\alias{PSDIntegrationPerFreqBin}
\title{Given a time series vector, generate a PSD, then calculate integration for specified bins}
\usage{
PSDIntegrationPerFreqBin(sampling_frequency, data_vector, frequency_bins)
}
\arguments{
\item{sampling_frequency}{Numeric value specifying sampling frequency in hertz. If data is sampled once every second, then sampling frequency is 1 Hz. If data is sampled once every 2 seconds, then sampling frequency is 0.5 Hz.}

\item{data_vector}{Vector of numeric values. Timeseries vector of data.}

\item{frequency_bins}{A list of objects where each object is a vector with two elements. The first element is a numeric value specifying the start frequency of a bin. The second element is a numeric value specifying the end frequency of a bin. Each object corresponds to a new frequency bin for calculating integral. For integration, approxfun is used, so increment does not need to be specified.}
}
\value{
A list where each object is also a list. The nested list objects have the first element specifying the bin boundaries. The second element specifies the integral.
}
\description{
Given a time series vector, generate a PSD, then calculate integration for specified bins
}
\examples{

#Create a vector of time that represent times where data are sampled.
Fs = 100; #sampling frequency in Hz
T = 1/Fs; #sampling period
L = 1000; #length of time vector
t = (0:(L-1))*T; #time vector

#Form a signal (time series) that contains two frequencies:
#1. 10 Hz with amplitude of 1
#2. 25 Hz with amplitude of 2
S <- 1*sin(2*pi*10*t) + 2*sin(2*pi*25*t);

results <- MakePowerSpectralDensity(Fs, S)

frequencies <- results[[1]]

PSD <- results[[2]]

#dev.new()
plot(frequencies, PSD, type = "l")

bins <- list(
c(9, 11),
c(24,26),
c(9,26),
c(30,40)
)

integration.results <- PSDIntegrationPerFreqBin(Fs, S, bins)

message.captured <- list()

for(i in 1:length(integration.results)){

   message <- paste("Area in bin ", integration.results[[i]][[1]], " is ",
                   integration.results[[i]][[2]])

   message.captured[[i]] <- message

}

}
