% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windows.R
\name{CountWindows}
\alias{CountWindows}
\title{Create a contingency table to display how many windows (dataframes) fall into particular categories}
\usage{
CountWindows(
  list.of.windows,
  level1.column.name,
  level2.column.name,
  level1.categories,
  level2.categories
)
}
\arguments{
\item{list.of.windows}{A list of windows (dataframes) and each window can only have a single unique value for the two specified columns.}

\item{level1.column.name}{A String that specifies the column name to use for the first level of the contingency table. This column should only contain one unique value within each window.}

\item{level2.column.name}{A String that specifies the column name to use for the second level of the contingency table. This column should only contain one unique value within each window.}

\item{level1.categories}{A vector that specifies the possible labels in the level1 column. This will be used as the rows of the outputted matrix.}

\item{level2.categories}{A vector that specifies the possible labels in the level2 column. This will be used as the columns of the outputted matrix.}
}
\value{
A matrix which is formatted as a contingency table.
}
\description{
Given a List of homogeneous windows (dataframes where the two selected columns in each dataframe only
have one unique value), make a contingency table to show how many windows fall into each of the
categories in level1 and level2.
}
\details{
A List of homogeneous windows is inputted. For each window in the list, the columns specified by
level1.column.name and level2.column.name can only have one value (definition of homogeneous
window). The value of the level1.column and level2.column for each window is evaluated
and the number of windows in each category is captured and outputted as a 2D matrix
with level1 as the row labels and level2 as the column labels.
}
\examples{

#Example using a dataframe with 5 homogeneous windows.

#Windows are homogeneous if looking at col.two and col.three values.
window.name.column <- c(10, 10, 10, 20, 20, 20, 30, 30, 30, 30, 40, 40, 50, 50, 50, 50)
col.two <- c("a", "a", "a", "a", "a", "a", "a", "a", "a", "a", "b", "b", "a", "a", "a", "a")
col.three <- c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 3, 3, 3, 3)

multi.window.data <- data.frame(window.name.column, col.two, col.three)

list.of.homogeneous.windows <- GetHomogeneousWindows(multi.window.data,
"window.name.column", c("col.two", "col.three"))

matrix <- CountWindows(list.of.homogeneous.windows, "col.two", "col.three",
c("a", "b"), c("1", "2", "3"))

matrix


}
