% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_cont_normal.R
\docType{class}
\name{OutcomeContinuousNormal-class}
\alias{OutcomeContinuousNormal-class}
\alias{.outcome_cont_normal}
\title{\code{OutcomeContinuousNormal} class}
\description{
A class for defining a regression with a normal outcome
to be translated to Stan code.
Objects of class \code{OutcomeContinuousNormal} should not be created directly but by
the constructor \code{\link[=outcome_cont_normal]{outcome_cont_normal()}}.
}
\section{Slots}{

\describe{
\item{\code{function_stan_code}}{character. stan function code block containing text to interpolate into stan model.
Empty string for \code{OutcomeContinuousNormal}.}

\item{\code{param_stan_code}}{character. stan parameter code block containing text to interpolate into stan model.
Empty string for \code{OutcomeContinuousNormal}.}

\item{\code{likelihood_stan_code}}{character. stan model likelihood code block containing text
to interpolate into stan model.}

\item{\code{n_param}}{integer. Number of ancillary parameters for the model to estimate (0).}

\item{\code{param_priors}}{list. Named list of prior distributions on the ancillary parameters in the model.
Empty for \code{OutcomeContinuousNormal}.}

\item{\code{continuous_var}}{character. Variable used for outcome in \code{OutcomeContinuousNormal} objects.}

\item{\code{baseline_prior}}{\code{Prior}. Object of class \code{Prior}
specifying prior distribution for the baseline outcome.}

\item{\code{name_beta_trt.}}{Named vector for beta_trt.}

\item{\code{name_exp_trt.}}{Named vector for exponentiated beta_trt}

\item{\code{alpha_type.}}{How to interpret alpha.}

\item{\code{name_addnl_params.}}{Named vector for additional parameters.}
}}

\seealso{
Other outcome: 
\code{\link{BinaryOutcome-class}},
\code{\link{ContinuousOutcome-class}},
\code{\link{Outcome-class}},
\code{\link{OutcomeBinaryLogistic-class}},
\code{\link{OutcomeSurvExponential-class}},
\code{\link{OutcomeSurvWeibullPH-class}},
\code{\link{TimeToEvent-class}}
}
\concept{outcome}
