% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_ids.R
\name{qc_ids}
\alias{qc_ids}
\title{Check number of precursor, peptide or protein IDs}
\usage{
qc_ids(
  data,
  sample,
  grouping,
  intensity,
  remove_na_intensities = TRUE,
  condition = NULL,
  title = "ID count per sample",
  plot = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame containing at least sample names and precursor/peptide/protein IDs.}

\item{sample}{the column in the data frame specifying the sample name.}

\item{grouping}{the column in the data frame containing either precursor, peptide or protein identifiers.}

\item{intensity}{the column in the data frame containing raw or log2 transformed intensities. If \code{remove_na_intensities = FALSE}, this argument is not required.}

\item{remove_na_intensities}{logical specifying if sample/grouping combinations with intensities that are NA (not quantified IDs) should be dropped from the data frame.
Default is TRUE since we are usually interested in the number of quantifiable IDs.}

\item{condition}{optional column in the data frame specifying the condition of the sample (e.g. LiP_treated, LiP_untreated),
if column is provided, the bars in the plot will be coloured according to the condition.}

\item{title}{optional argument specifying the plot title (default is "ID count per sample").}

\item{plot}{logical specifying whether the output of the function should be plotted (default is TRUE).}

\item{interactive}{logical specifying whether the plot should be interactive (default is FALSE).}
}
\value{
A bar plot with the height corresponding to the number of IDs, each bar represents one sample
(if \code{plot = TRUE}). If \code{plot = FALSE} a table with ID counts is returned.
}
\description{
Returns a plot or table of the number of IDs for each sample. The default settings remove grouping variables without quantitative information (intensity is NA).
These will not be counted as IDs.
}
\examples{
\dontrun{
qc_ids(
  data,
  sample = r_file_name,
  grouping = eg_precursor_id,
  intensity = fg_quantity,
  condition = r_condition,
  title = "Number of peptide IDs per sample"
)
}
}
