\name{gapDer}
\alias{gapDer}
\title{Gap-Segment Derivative}
\usage{
  gapDer(X, m = 1, w = 1, s = 1, delta.wav)
}
\arguments{
  \item{X}{numeric \code{matrix} , \code{data.frame} or
  \code{vector} to transform}

  \item{m}{order of the derivative, between 1 and 4
  (default = 1)}

  \item{w}{filter length (should be odd and >=1), i.e. the
  spacing between points over which the derivative is
  computed}

  \item{s}{segment size, i.e. the range over which the
  points are averaged (default = 1, i.e. no smoothing
  corresponding to 'Norris' Gap Derivative)}

  \item{delta.wav}{sampling interval (or band spacing)}
}
\value{
  a \code{matrix} or \code{vector} with the filtered
  signal(s)
}
\description{
  Gap-Segment derivatives of a data \code{matrix},
  \code{data.frame} or \code{vector}
}
\details{
  The sampling interval specified with the \code{delta.wav}
  argument is used for scaling and get numerically correct
  derivatives.

  The convolution function is written in C++/Rcpp for
  faster computations.
}
\examples{
data(NIRsoil)
spc <- 1/10^NIRsoil$spc # conversion to reflectance
opar <- par(no.readonly = TRUE)
par(mfrow=c(2,2),mar=c(4,4,2,2))
# plot of the 10 first spectra
matplot(as.numeric(colnames(spc)),t(spc[1:10,]),
        type='l',xlab='',ylab='Reflectance')
mtext('Raw spectra')
der <- gapDer(spc,m=1,w=1,s = 1,delta.wav=2)
matplot(as.numeric(colnames(der)),t(der[1:10,]),
        type='l',xlab='Wavelength /nm',ylab='gap derivative')
mtext('1st derivative spectra')
der <- gapDer(spc,m=1,w=11,s = 1,delta.wav=2)
matplot(as.numeric(colnames(der)),t(der[1:10,]),
        type='l',xlab='Wavelength /nm',ylab='gap derivative')
mtext('1st derivative spectra with a window size = 11 nm')
der <- gapDer(spc,m=1,w=11,s = 10,delta.wav=2)
matplot(as.numeric(colnames(der)),t(der[1:10,]),
        type='l',xlab='Wavelength /nm',ylab='gap derivative')
mtext('1st derivative spectra with a window size = 11 nm, smoothing of 10 nm')
par(opar)
}
\author{
  Antoine Stevens
}
\references{
  Hopkins (2002). NIR News 14(5), 10.
}
\seealso{
  \code{\link[signal]{sgolayfilt}},
  \code{\link{savitzkyGolay}}, \code{\link{movav}},
  \code{\link{binning}}, \code{\link{continuumRemoval}}
}

