% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propr-classes.R
\docType{class}
\name{propr-class}
\alias{propr-class}
\title{An S4 class to hold results from proportionality analysis.}
\description{
An S4 class to hold results from proportionality analysis.
}
\section{Slots}{

\describe{
\item{\code{counts}}{A data.frame. Stores the original "count matrix" input.}

\item{\code{logratio}}{A data.frame. Stores the log-ratio transformed "count matrix".}

\item{\code{matrix}}{A matrix. Stores the proportionality matrix calculated by \code{phit} or \code{perb}.}

\item{\code{pairs}}{A data.frame. Projects the proportionality matrix pairwise.}
}}
\examples{
randomNum <- sample(1:1000, size = 25 * 10, replace = TRUE)
counts <- matrix(randomNum, nrow = 25, ncol = 10)
prop <- perb(counts, ivar = 0, iter = 0)
prop[1:5, ]
prop$prop
prop[1:5, "prop"]
subset(prop, 1:5)
}
\seealso{
\code{\link{propr}}, \code{\link{phit}}, \code{\link{perb}}
}

