% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promote.R
\name{promote.library}
\alias{promote.library}
\title{Import one or more libraries and add them to the promote model's
dependency list}
\usage{
promote.library(name, src = "CRAN", version = NULL, user = NULL,
  install = TRUE)
}
\arguments{
\item{name}{name of the package to be added}

\item{src}{source from which the package will be installed on Promote (github or CRAN)}

\item{version}{version of the package to be added}

\item{user}{Github username associated with the package}

\item{install}{Whether the package should also be installed into the model on the
Promote server; this is typically set to False when the package has already been
added to the Promote base image.}
}
\description{
Import one or more libraries and add them to the promote model's
dependency list
}
\examples{
\dontrun{
promote.library("MASS")
promote.library(c("wesanderson", "stringr"))
promote.library("cats", src="github", user="hilaryparker")
promote.library("hilaryparker/cats")
promote.library("my_proprietary_package", install=FALSE)
}
}
\keyword{import}
