% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zone_names.R
\name{zone_names}
\alias{zone_names}
\alias{zone_names.ConservationProblem}
\alias{zone_names.ZonesRaster}
\alias{zone_names.ZonesSpatRaster}
\alias{zone_names.ZonesCharacter}
\title{Zone names}
\usage{
zone_names(x, ...)

\method{zone_names}{ConservationProblem}(x, ...)

\method{zone_names}{ZonesRaster}(x, ...)

\method{zone_names}{ZonesSpatRaster}(x, ...)

\method{zone_names}{ZonesCharacter}(x, ...)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} or \code{\link[=zones]{zones()}} object.}

\item{...}{not used.}
}
\value{
A \code{character} vector of zone names.
}
\description{
Extract the names of zones in an object.
}
\examples{
\dontrun{
# load data
sim_zones_pu_raster <- get_sim_zones_pu_raster()
sim_zones_features <- get_sim_zones_features()

# print names of zones in a Zones object
print(zone_names(sim_zones_features))
# create problem with multiple zones
p <-
  problem(sim_zones_pu_raster, sim_zones_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(matrix(0.2, ncol = 3, nrow = 5)) \%>\%
  add_binary_decisions()

# print zone names in problem
print(zone_names(p))
}
}
