% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marxan_boundary_data_to_matrix.R
\name{marxan_boundary_data_to_matrix}
\alias{marxan_boundary_data_to_matrix}
\title{Convert \emph{Marxan} boundary data to matrix format}
\usage{
marxan_boundary_data_to_matrix(x, data)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} object that
contains planning unit and zone data to ensure that the argument to
\code{data} is converted correctly. This argument can be set to
\code{NULL} if checks are not required (not recommended).}

\item{data}{\code{data.frame} object with the columns \code{"id1"},
\code{"id2"}, and \code{"boundary"}.}
}
\value{
A \code{\linkS4class{dgCMatrix}} sparse matrix object.
}
\description{
Convert a \code{data.frame} object containing \emph{Marxan} boundary data
to matrix format. This function is designed specifically for
boundary data (not connectivity data).
It ensures that the output matrix correctly specifies
symmetric spatial relationships between planning units.
}
\section{Notes}{

In earlier versions, the function could convert boundary data
that pertain to multiple zones. This is no longer possible, following
updates to streamline the package.
}

\examples{
# create marxan boundary with four planning units and one zone
bldf1 <- expand.grid(id1 = seq_len(4), id2 = seq_len(4))
bldf1$boundary <- 1
bldf1$boundary[bldf1$id1 == bldf1$id2] <- 0.5

# convert to matrix
m1 <- marxan_boundary_data_to_matrix(NULL, bldf1)

# visualize matrix
\dontrun{
image(m1)
}
}
