% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ferrier_score.R
\name{ferrier_score}
\alias{ferrier_score}
\alias{ferrier_score,ConservationProblem,numeric-method}
\alias{ferrier_score,ConservationProblem,matrix-method}
\alias{ferrier_score,ConservationProblem,data.frame-method}
\alias{ferrier_score,ConservationProblem,Spatial-method}
\alias{ferrier_score,ConservationProblem,Raster-method}
\title{Ferrier irreplaceability score}
\usage{
ferrier_score(x, solution)

\S4method{ferrier_score}{ConservationProblem,numeric}(x, solution)

\S4method{ferrier_score}{ConservationProblem,matrix}(x, solution)

\S4method{ferrier_score}{ConservationProblem,data.frame}(x, solution)

\S4method{ferrier_score}{ConservationProblem,Spatial}(x, solution)

\S4method{ferrier_score}{ConservationProblem,Raster}(x, solution)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e. \code{\linkS4class{ConservationProblem}}) object.}

\item{solution}{\code{numeric}, \code{matrix}, \code{data.frame},
\code{\linkS4class{Raster}}, or \code{\linkS4class{Spatial}}
object. See the Details section for more information.}
}
\value{
A \code{matrix}, \code{\link[tibble:tibble]{tibble::tibble()}},
\code{\linkS4class{RasterLayer}}, or
\code{\linkS4class{Spatial}} object containing the scores for each
planning unit selected in the solution.
}
\description{
Calculate irreplaceability scores for planning units selected in
a solution using the method outlined in Ferrier \emph{et al.} (2000).
Here, scores are calculated separately for each feature within
each planning unit. Additionally, a total irreplaceability score is also
calculated as the sum of the irreplaceability scores for each planning unit.
Note that this function only works for problems with
a minimum set objective and a single zone.
It will throw an error for other types of problems. \strong{Please note that
the mathematical formulation for computing these scores needs to be double
checked by an expert, and so this functionality should be considered
experimental at this point in time.}
}
\details{
The argument to \code{solution} must correspond
to the planning unit data in the argument to \code{x} in terms
of data representation, dimensionality, and spatial attributes (if
applicable). This means that if the planning unit data in \code{x}
is a \code{numeric} vector then the argument to \code{solution} must be a
\code{numeric} vector with the same number of elements, if the planning
unit data in \code{x} is a \code{\linkS4class{RasterLayer}} then the
argument to \code{solution} must also be a
\code{\linkS4class{RasterLayer}} with the same number of rows and
columns and the same resolution, extent, and coordinate reference system,
if the planning unit data in \code{x} is a \code{\linkS4class{Spatial}}
object then the argument to \code{solution} must also be a
\code{\linkS4class{Spatial}} object and have the same number of spatial
features (e.g. polygons) and have the same coordinate reference system,
if the planning units in \code{x} are a \code{data.frame} then the
argument to \code{solution} must also be a \code{data.frame} with each
column correspond to a different zone and each row correspond to
a different planning unit, and values correspond to the allocations
(e.g. values of zero or one). Furthermore, solutions must have planning
unit statuses set to missing (\code{NA})
values for planning units that have missing (\code{NA}) cost data.
If an argument is supplied to
\code{solution} where this is not the case, then an error will be thrown.
}
\examples{
# seed seed for reproducibility
set.seed(600)

# load data
data(sim_pu_raster, sim_features)

# create minimal problem with binary decisions
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.1) \%>\%
      add_binary_decisions() \%>\%
      add_default_solver(gap = 0, verbose = FALSE)
\dontrun{
# solve problem
s1 <- solve(p1)

# print solution
print(s1)

# plot solution
plot(s1, main = "solution", axes = FALSE, box = FALSE)

# calculate irreplaceability scores using Ferrier et al. 2000 method
fs1 <- ferrier_score(p1, s1)

# print irreplaceability scores,
# each planning unit has an irreplaceability score for each feature
# (as indicated by the column names) and each planning unit also
# has an overall total irreplaceability score (in the "total" column)
print(fs1)

# plot total irreplaceability scores
plot(fs1, axes = FALSE, box = FALSE)
}

}
\references{
Ferrier S, Pressey RL, and Barrett TW (2000) A new predictor of the
irreplaceability of areas for achieving a conservation goal, its application
to real-world planning, and a research agenda for further refinement.
\emph{Biological Conservation}, 93: 303--325.
}
\seealso{
\link{irreplaceability}.
}
