% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_extract.R
\name{fast_extract}
\alias{fast_extract}
\alias{fast_extract,Raster,SpatialLines-method}
\alias{fast_extract,Raster,SpatialPoints-method}
\alias{fast_extract,Raster,SpatialPolygons-method}
\alias{fast_extract,Raster,sf-method}
\alias{fast_extract,Raster,sfc-method}
\title{Fast extract}
\usage{
fast_extract(x, y, ...)

\S4method{fast_extract}{Raster,SpatialPolygons}(x, y, fun = "mean", ...)

\S4method{fast_extract}{Raster,SpatialPoints}(x, y, fun = "mean", ...)

\S4method{fast_extract}{Raster,SpatialLines}(x, y, fun = "mean", ...)

\S4method{fast_extract}{Raster,sfc}(x, y, fun = "mean", ...)

\S4method{fast_extract}{Raster,sf}(x, y, fun = "mean", ...)
}
\arguments{
\item{x}{\code{\link[raster]{Raster-class}} object.}

\item{y}{\code{\link[sp]{Spatial-class}} or
\code{\link[sf]{sf}} object.}

\item{...}{not used.}

\item{fun}{\code{character} name of statistic to summarize data. Defaults
to \code{"mean"}. Available options include \code{"sum"} or \code{"mean"}.
Defaults to \code{"mean"}.}
}
\value{
\code{matrix} containing the summary amount of each feature
   within each planning unit. Rows correspond to different spatial features
  in the argument to \code{y} and columns correspond to different raster
  layers in the argument to \code{x}.
}
\description{
Extract data from a \code{\link[raster]{Raster-class}} object.
}
\details{
This function is simply a wrapper that uses
  \code{\link[raster]{extract}} to extract data for
  \code{\link[sp]{SpatialPoints-class}} and
  \code{\link[sp]{SpatialLines-class}} and
  non-polygonal \code{\link[sf]{sf}} data, and
  \code{\link[exactextractr]{exact_extract}} for
  \code{\link[sp]{SpatialPolygons-class}} and
  polygonal \code{\link[sf]{sf}} data.
}
\examples{
# load data
data(sim_pu_sf, sim_features)

# extract data
result <- fast_extract(sim_features, sim_pu_sf)

# show result
print(head(result))

}
\seealso{
\code{\link[raster]{extract}},
  \code{\link[exactextractr]{exact_extract}}.
}
