% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_cost}
\alias{simulate_cost}
\title{Simulate cost data}
\usage{
simulate_cost(x, n = 1,
  model = RandomFields::RPpoisson(RandomFields::RMtruncsupport(radius =
  raster::xres(x) * 10, RandomFields::RMgauss())), transform = identity,
  ...)
}
\arguments{
\item{x}{\code{\link[raster]{RasterLayer-class}} object to use as}

\item{n}{\code{integer} number of species to simulate.}

\item{model}{\code{\link[RandomFields]{RP}} model object
to use for simulating data.}

\item{transform}{\code{function} to transform values output
from the random fields simulation.}

\item{...}{additional arguments passed to
\code{\link[RandomFields]{RFsimulate}}.}
}
\value{
\code{\link[raster]{RasterStack-class}} object.
}
\description{
This function generates cost layers using random field models. By default,
it returns spatially autocorrelated integer values.
}
\examples{
\donttest{
# create raster
r <- raster(ncol=10, nrow=10, xmn=0, xmx=1, ymn=0, ymx=1)
values(r) <- 1

# simulate data
cost <- simulate_cost(r)

# plot simulated species
plot(cost, main = "simulated cost data")
}

}
\seealso{
\code{\link{simulate_data}}.
}
