% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pool_portfolio.R
\name{add_pool_portfolio}
\alias{add_pool_portfolio}
\alias{add_pool_portfolio}
\title{Add a pool portfolio}
\usage{
add_pool_portfolio(x, method = 0, number_solutions = 10)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{method}{\code{numeric} search method identifier that determines how
multiple solutions should be generated. Available search modes for
generating a portfolio of solutions include: \code{0}
recording all solutions identified whilst trying to find
a solution that is within the specified optimality gap, \code{1} finding
one solution within the optimality gap and a number of additional
solutions that are of any level of quality (such that the total number of
solutions is equal to \code{number_solutions}), and \code{2} finding a
specified number of solutions that are nearest to optimality. These
search methods correspond to the parameters used by the \emph{Gurobi}
software suite (see \url{http://www.gurobi.com/documentation/8.0/refman/poolsearchmode.html#parameter:PoolSearchMode}).
Defaults to 0.}

\item{number_solutions}{\code{integer} number of attempts to generate
different solutions. Note that this argument has no effect if the
argument to \code{method} is \code{0}. Defaults to 10.}
}
\value{
\code{\link{ConservationProblem-class}} object with the portfolio
  added to it.
}
\description{
Generate a portfolio of solutions for a conservation planning
\code{\link{problem}} by extracting all the feasible solutions
discovered during the optimization process.
}
\details{
This strategy for generating a portfolio requires problems to
  be solved using the \emph{Gurobi} software suite (i.e. using
  \code{\link{add_gurobi_solver}}. Specifically, version 8.0.0 (or greater)
  of the \pkg{gurobi} package must be installed. \strong{Please note that
  although the solution pool methods are faster than the other methods
  for generating portfolios of solutions, none of the pool methods
  are guaranteed to return only solutions within a specified optimality gap.
  Also, except for when the \code{method} argument is set to 2, none of
  the search methods provide any guarantees on the number of returned
  solutions.}
}
\examples{
# set seed for reproducibility
set.seed(500)

# load data
data(sim_pu_raster, sim_features, sim_pu_zones_stack, sim_features_zones)
\donttest{
# create minimal problem with pool portfolio
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.2) \%>\%
      add_pool_portfolio() \%>\%
      add_default_solver(gap = 0.02, verbose = FALSE)

# solve problem
s1 <- solve(p1)

# print number of solutions found
print(length(s1))

# plot solutions
plot(stack(s1), axes = FALSE, box = FALSE)

# create minimal problem with pool portfolio and find the top 5 solutions
p2 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.5) \%>\%
      add_pool_portfolio(method = 2, number_solutions = 5) \%>\%
      add_default_solver(gap = 0, verbose = FALSE)

# solve problem
s2 <- solve(p2)

# print number of solutions found
print(length(s2))

# plot solutions
plot(stack(s2), axes = FALSE, box = FALSE)

# build multi-zone conservation problem with pool portfolio
p3 <- problem(sim_pu_zones_stack, sim_features_zones) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(matrix(runif(15, 0.1, 0.2), nrow = 5,
                                  ncol = 3)) \%>\%
      add_binary_decisions() \%>\%
      add_pool_portfolio() \%>\%
      add_default_solver(gap = 0.02, verbose = FALSE)

# solve the problem
s3 <- solve(p3)

# print number of solutions found
print(length(s3))

# print solutions
str(s3, max.level = 1)

# plot solutions in portfolio
plot(stack(lapply(s3, category_layer)), main = "solution", axes = FALSE,
     box = FALSE)
}
}
\seealso{
\code{\link{portfolios}}.
}
