% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialize_df.R, R/structure_for_serialization.R
\name{serialize_df}
\alias{serialize_df}
\alias{structure_for_serialization}
\title{"Serialize" a data frame or (pre)registration specification}
\usage{
serialize_df(x, idCol = NULL)

structure_for_serialization(x)
}
\arguments{
\item{x}{For \code{serialize_df}, a data frame; for
\code{structure_for_serialization}, the (pre)registration specification}

\item{idCol}{If not \code{NULL}, the name of a column in the data frame to use
as names for the lists.}
}
\value{
The restructured list
}
\description{
When exporting a (pre)registration specification to YAML or JSON, the most
human-readable format differs from the way data frames are comprised of
lists. Data frames are lists that are bound together as columns; and so,
when saving a data frame to YAML or JSON, the data in each column is
combined (e.g. first all item identifiers, then all item labels, then all
item descriptions, etc). However, for humans, it makes more sense to
have all data belonging to the same item close together. These functions
do that processing.
}
