% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial-pref.r
\name{overall_power_binom}
\alias{overall_power_binom}
\title{Power Calculation from Sample Size}
\usage{
overall_power_binom(
  N,
  phi,
  p11,
  p22,
  p1,
  p2,
  alpha = 0.05,
  theta = 0.5,
  xi = 1,
  nstrata = 1
)
}
\arguments{
\item{N}{overall study sample size.}

\item{phi}{the proportion of patients preferring treatment 1. Should be
numeric value between 0 and 1. If study is stratified, should be
vector with length equal to the number of strata in the study.}

\item{p11}{response proportion of patients choosing to receive treatment 1 
in the choice arm. Should be numeric value between 0 and 1. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{p22}{response proportion of patients choosing to receive treatment 2 
in the choice arm. Should be numeric value between 0 and 1. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{p1}{response proportion of patients randomized to receive treatment 1 
in the random arm. Should be numeric value between 0 and 1. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{p2}{response proportion of patients randomized to receive treatment 2 
in the random arm. Should be numeric value between 0 and 1. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{alpha}{desired type I error rate.}

\item{theta}{proportion of patients assigned to choice arm in the initial
randomization. Should be numeric value between
0 and 1 (default=0.5).}

\item{xi}{a numeric vector of the proportion of patients in each stratum. 
Length of vector should equal the number of strata in the study and 
sum of vector should be 1. All vector elements should be numeric 
values between 0 and 1. Default is 1 (i.e. unstratified design).}

\item{nstrata}{number of strata. Default is 1 (i.e. unstratified design).}
}
\description{
Calculates the study power to detect the preference effect given a particular 
sample size in a two-stage randomized clinical trial with a binary outcome measure
}
