% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_surv.R
\name{data.preproc.surv}
\alias{data.preproc.surv}
\title{Data preprocessing
Apply at the beginning of \code{catefitcount()}, \code{catecvcount()}, \code{catefitsurv()}, and \code{catecvsurv()}, after \code{arg.checks()}}
\usage{
data.preproc.surv(
  fun,
  cate.model,
  ps.model,
  ipcw.model = NULL,
  tau0 = NULL,
  data,
  prop.cutoff = NULL,
  prop.multi = NULL,
  ps.method,
  initial.predictor.method = NULL,
  response = "count"
)
}
\arguments{
\item{fun}{A function for which argument check is needed; "catefit" for \code{catefitcount()} and \code{catefitsurv()},
"crossv" for \code{catecvcount()} and \code{catecvsurv()},
and "drinf" for \code{drcount.inference()} and \code{drsurv.inference()}. No default.}

\item{cate.model}{A formula describing the outcome model to be fitted.
The outcome must appear on the left-hand side.}

\item{ps.model}{A formula describing the propensity score model to be fitted.
The treatment must appear on the left-hand side. The treatment must be a numeric vector
coded as 0/1. If data are from a RCT, specify \code{ps.model} as an intercept-only model.}

\item{ipcw.model}{A formula describing inverse probability of censoring weighting(IPCW) model to be fitted.
If covariates are the same as outcome model, set \code{ipcw.model = NULL}.
Otherwise, the left-hand side must be empty and the right-hand side is a covariates model.}

\item{tau0}{The truncation time for defining restricted mean time lost. Default is \code{NULL},
which corresponds to setting the truncation time as the maximum survival time in the data}

\item{data}{A data frame containing the variables in the outcome, propensity score, and IPCW models;
a data frame with \code{n} rows (1 row per observation).}

\item{prop.cutoff}{A vector of numerical values (in (0, 1]) specifying percentiles of the
estimated log CATE scores to define nested subgroups. Each element represents the cutoff to
separate observations in nested subgroups (below vs above cutoff).
The length of \code{prop.cutoff} is the number of nested subgroups.
An equally-spaced sequence of proportions ending with 1 is recommended.
Default is \code{seq(0.5, 1, length = 6)}.}

\item{prop.multi}{A vector of numerical values (in [0, 1]) specifying percentiles of the
estimated log CATE scores to define mutually exclusive subgroups.
It should start with 0, end with 1, and be of \code{length(prop.multi) > 2}.
Each element represents the cutoff to separate the observations into
\code{length(prop.multi) - 1} mutually exclusive subgroups.
Default is \code{c(0, 1/3, 2/3, 1)}.}

\item{ps.method}{A character value for the method to estimate the propensity score.
Allowed values include one of:
\code{'glm'} for logistic regression with main effects only (default), or
\code{'lasso'} for a logistic regression with main effects and LASSO penalization on
two-way interactions (added to the model if interactions are not specified in \code{ps.model}).
Relevant only when \code{ps.model} has more than one variable.}

\item{initial.predictor.method}{A character vector for the method used to get initial
outcome predictions conditional on the covariates. Only applies when \code{score.method}
includes \code{'twoReg'} or \code{'contrastReg'}. Allowed values include one of
\code{'randomForest'} (survival outcomes only), \code{'boosting'}, \code{'logistic'}
(survival outcomes only, fast), \code{'poisson'} (count outcomes only, fast), and
\code{'gam'} (count outcomes only). Default is \code{NULL}, which assigns \code{'boosting'}
for count outcomes and \code{'randomForest'} for survival outcomes.}

\item{response}{The type of response variables; \code{count} (default) or \code{survival}.}
}
\value{
A list of elements:
           - y: outcome; vector of length \code{n} (observations)
           - d : the event indicator; vector of length \code{n}; only if \code{respone = "survival"}
           - trt: binary treatment; vector of length \code{n}
           - x.ps: matrix of \code{p.ps} baseline covariates specified in the propensity score model (plus intercept); dimension \code{n} by \code{p.ps + 1}
           - x.cate: matrix of \code{p.cate} baseline covariates specified in the outcome model; dimension \code{n} by \code{p.cate}
           - x.ipcw: matrix of \code{p.ipw} baseline covarites specified in inverse probability of censoring weighting model; dimension \code{n} by \code{p.ipw}
           - time: offset; vector of length \code{n}; only if \code{response = "count"}
           - if \code{fun = "catefit"}:
               - prop: formatted \code{prop.cutoff}
               - prop.no1: formatted \code{prop.cutoff} with 1 removed if applicable; otherwise prop.no1 is the same as prop
           - if \code{fun = "crossv"}
               - prop.onlyhigh: formatted \code{prop.cutoff} with 0 removed if applicable
               - prop.bi; formatted \code{prop.cutoff} with 0 and 1 removed if applicable
               - prop.multi: formatted \code{prop.multi}, starting with 0 and ending with 1
}
\description{
Data preprocessing
Apply at the beginning of \code{catefitcount()}, \code{catecvcount()}, \code{catefitsurv()}, and \code{catecvsurv()}, after \code{arg.checks()}
}
