% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{kInverse}
\alias{kInverse}
\title{Inverse Kendall transform}
\usage{
kInverse(x)
}
\arguments{
\item{x}{A Kendall-transformed feature to be converted back into a ranking.
To be interpreted as a such, it must be a factor with levels being a subset of \code{'<'}, \code{'>'} or \code{'='}.
Alternatively, it may be a numeric vector of greater-than scores.}
}
\value{
Vector of ranks corresponding to \code{x}.
}
\description{
This function attempts to reverse Kendall transformation using a simple ranking agreement method, which always restores original ranking if the input corresponds to one, or a reasonable best-effort guess if not.
Namely, each objects gets a score based on its relation with each other object, 2 points for a win (\code{'>'}) and 1 point for a tie (\code{'='}); these scores are used to calculate ranks.
This function can also be directly given greater-than scores, for instance confidence scores from some classifier trained on Kendall-transformed data.
}
\note{
An order of elements in \code{x} is crucial; if it is not the same as generated by the \code{\link{kTransform}}, results will be wrong.
This function cannot assert that the order is correct.
}
\examples{
kInverse(kTransform(1:7))
}
\references{
Kendall transformation M.B. Kursa, arXiv:2006.15991 (2020).
}
