\name{hprabclust}
\alias{hprabclust}
\alias{print.comprabclust}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Clustering of species ranges from presence-absence matrices
  (hierarchical methods)}
\description{
  Clusters a presence-absence matrix object by taking the
  'h-cut'-partition of a hierarchical clustering and
  declaring all members of too small clusters as 'noise' (this gives a
  distance-based clustering method, which estimates the number of
  clusters and allows for noise/non-clustered points). Note that this
  is experimental. Often, the \code{prabclust}-solutions
  is more convincing due to higher flexibility of that method. However,
  \code{hprabclust} may be more stable sometimes.
  
  \bold{Note:} Data formats are described
  on the \code{prabinit} help page. You may also consider the example datasets
  \code{kykladspecreg.dat} and \code{nb.dat}. Take care of the
  parameter \code{rows.are.species} of \code{prabinit}.
}

\usage{
hprabclust(prabobj, cutdist=0.4, cutout=1,
method="average", nnout=2, mdsplot=TRUE, mdsmethod="classical")

\method{print}{comprabclust}(x, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{prabobj}{object of class \code{prab} as
    generated by \code{prabinit}. Presence-absence data to be analyzed.}
  \item{cutdist}{non-negative integer. Cutoff distance to determine the
    partition, see \code{cutree}.}
  \item{cutout}{non-negative integer. Points that have at most
    \code{nnout} distances smaller or equal than \code{cutout} are
    treated as noise.}
  \item{method}{string. Clustering method, see \code{hclust}.}
  \item{nnout}{non-negative integer. Members of clusters with less or
    equal than \code{nnout} points or that have less or equal than
    \code{nnout} neighbors closer than \code{cutout} are treated as noise.}
  \item{mdsplot}{logical. If \code{TRUE}, the cluster solution is
    plotted on the first two MDS dimensions, see \code{mdsmethod}.}
  \item{mdsmethod}{\code{"classical"}, \code{"kruskal"}, or
    \code{"sammon"}. The MDS method
    to transform the distances to data points. \code{"classical"} indicates
    metric MDS by function \code{cmdscale}, \code{"kruskal"} is
    non-metric MDS. Note that if \code{mdsmethod!="classical"} zero
    distances between different objects are replaced by the minimum of
    the nonzero distances divided by 10 (otherwise the MDS method would
    produce an error). Note that \code{mdsmethod} is ignored if
    \code{mdsplot=FALSE}.}
  \item{x}{\code{comprabclust}-object as generated by \code{hprabclus}.}
  \item{...}{necessary for print method.}
}

\value{
  \code{hprabclust} generates an object of class \code{comprabclust}. This is a
  list with components
  \item{clustering}{vector of integers indicating the cluster memberships of
    the species (\code{cutout}-outliers are noise, but small clusters
    are allowed). Noise is coded as 0.}
  \item{rclustering}{vector of integers indicating the cluster memberships of
    the species, noise as described under \code{nnout}.
    Noise is coded as 0.}
  \item{cutdist}{see above.}
  \item{method}{see above.}
  \item{cutout}{see above.}
  \item{nnout}{see above.}
  \item{noisen}{number of points minus \code{cutout}-outliers.}
  \item{symbols}{vector of characters corresponding to \code{rclustering}, but
    estimated noise by \code{"N"}.}
  \item{points}{numerical matrix. MDS configuration (if \code{mdsplot=TRUE}).}
  \item{call}{function call.}
}

\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche}}

\seealso{
  \code{\link{hclust}}, \code{\link{cutree}},
  \code{\link{prabclust}}.
}

\examples{
data(kykladspecreg)
data(nb)
data(waterdist)
x <- prabinit(prabmatrix=kykladspecreg, neighborhood=nb,
              geodist=waterdist, distance="geco")
hprabclust(x,mdsplot=FALSE)
}
\keyword{cluster}% at least one, from doc/KEYWORDS
\keyword{spatial}% __ONLY ONE__ keyword per line
