% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rejection_rates.R
\name{rejection_rates}
\alias{rejection_rates}
\alias{rejection_rates.default}
\alias{rejection_rates.power4test}
\alias{rejection_rates.power4test_by_es}
\alias{rejection_rates.power4test_by_n}
\alias{print.rejection_rates_df}
\title{Rejection Rates}
\usage{
rejection_rates(object, ...)

\method{rejection_rates}{default}(object, ...)

\method{rejection_rates}{power4test}(
  object,
  all_columns = FALSE,
  ci = TRUE,
  level = 0.95,
  se = FALSE,
  collapse = c("none", "all_sig", "at_least_one_sig", "at_least_k_sig"),
  at_least_k = 1,
  ...
)

\method{rejection_rates}{power4test_by_es}(
  object,
  all_columns = FALSE,
  ci = TRUE,
  level = 0.95,
  se = FALSE,
  ...
)

\method{rejection_rates}{power4test_by_n}(
  object,
  all_columns = FALSE,
  ci = TRUE,
  level = 0.95,
  se = FALSE,
  ...
)

\method{print}{rejection_rates_df}(x, digits = 3, annotation = TRUE, abbreviate_col_names = TRUE, ...)
}
\arguments{
\item{object}{The object
from which the rejection rates
are to be computed, such as
a \code{power4test} object,
a \code{power4test_by_n} object,
or a \code{power4test_by_es} object.}

\item{...}{Optional arguments. For
the \code{print} method, these arguments
will be passed to the \code{print} method
of \code{data.frame} objects \code{\link[=print.data.frame]{print.data.frame()}}.
Not used by other methods.}

\item{all_columns}{If \code{TRUE}, all
columns stored by a test will be
extracted. Default is \code{FALSE} and
only essential columns related to
power will be printed.}

\item{ci}{If \code{TRUE}, confidence
intervals for the rejection rates
(column \code{reject} or \code{sig}) will
be computed. Normal approximation
is used in forming the confidence
intervals.}

\item{level}{The level of confidence
for the confidence intervals, if
\code{ci} is \code{TRUE}. Default is .95,
denoting 95\%.}

\item{se}{If \code{TRUE}, standard errors
for the rejection rates
(column \code{reject} or \code{sig}) will
be computed. Normal approximation
is used to compute the standard
errors.}

\item{collapse}{Whether a single
decision (significant vs. not significant)
is made across all tests for a test
that consists of several tests
(e.g., the tests of several parameters).
If \code{"none"}, tests will be summarized
individually. If \code{"all_sig"}, then
the set of tests is considered significant
if all individual tests are significant.
If \code{"at_least_one_sig"}, then the set of
tests is considered significant if
at least one of the tests is significant.
If \code{"at_least_k_sig"}, then the set of
tests is considered significant if
at least \code{k} tests are significant,
\code{k} set by the argument \code{at_least_k}.}

\item{at_least_k}{Used by \code{collapse},
the number of tests required to be
significant for the set of tests to
be considered significant.}

\item{x}{The \code{rejection_rates_df}
object to be printed.}

\item{digits}{The number of digits
to be printed
after the decimal.}

\item{annotation}{Logical. Whether
additional notes will be printed.}

\item{abbreviate_col_names}{Logical.
Whether some column names will be
abbreviated.}
}
\value{
The \code{rejection_rates} method returns
a \code{rejection_rates_df} object,
with a \code{print} method.

If the input (\code{object}) is a
\code{power4test} object, the
\code{rejection_rates_df} object is
a data-frame like object with the
number of
rows equal to the number of tests.
Note that some tests, such as
the test by \code{\link[=test_parameters]{test_parameters()}},
conduct one test for each parameter.
Each such test is counted as one
test.

The data frame has at least these columns:
\itemize{
\item \code{test}: The name of the test.
\item \code{label}: The label for each
test, or \code{"Test"} if a test only
does one test (e.g., \code{\link[=test_indirect_effect]{test_indirect_effect()}}).
\item \code{pvalid}: The proportion of valid
tests across all replications.
\item \code{reject}: The rejection rate for
each test. If the null hypothesis
is false, then this is the power.
}

The \code{rejection_rates} method
for \code{power4test_by_es} objects
returns an object of the
class \code{rejection_rates_df_by_es},
which is a subclass of
\code{rejection_rates_df}.
It is a data frame which is
similar to the output of
\code{\link[=rejection_rates]{rejection_rates()}}, with two
columns added for the effect size (\code{pop_es_name} and
\code{pop_es_values})
for each test.

The \code{rejection_rates} method
for \code{power4test_by_n} objects
returns an object of the
class \code{rejection_rates_df_by_n},
which is a subclass of
\code{rejection_rates_df}.
It is a data frame which is
similar to the output of
a \code{power4test} object, with a
column \code{n} added for the sample size
for each test.

The \code{print} method of a
\code{rejection_rates_df} object returns
the object invisibly. It is called
for its side-effect.
}
\description{
Get all rejection rates
of all tests stored in a \code{power4test}
object or other supported objects.
}
\details{
For a \code{power4test} object,
\link{rejection_rates} loops over the tests stored
in a \code{power4test} object and retrieves
the rejection rate of each test.

The \code{rejection_rates} method for
\code{power4test_by_es} objects
is used to compute the rejection
rates from a \code{power4test_by_es}
object, with effect sizes added to
the output.

The \code{rejection_rates} method for
\code{power4test_by_n} objects
is used to compute the rejection
rates, with sample sizes added to
the output.
}
\examples{

# Specify the population model

model_simple_med <-
"
m ~ x
y ~ m + x
"

# Specify the effect sizes (population parameter values)

model_simple_med_es <-
"
y ~ m: l
m ~ x: m
y ~ x: n
"

# Generate some datasets to check the model

sim_only <- power4test(nrep = 4,
                       model = model_simple_med,
                       pop_es = model_simple_med_es,
                       n = 100,
                       R = 50,
                       ci_type = "boot",
                       fit_model_args = list(fit_function = "lm"),
                       do_the_test = FALSE,
                       iseed = 1234)

# Do the test 'test_indirect_effect' on each datasets

test_out <- power4test(object = sim_only,
                       test_fun = test_indirect_effect,
                       test_args = list(x = "x",
                                        m = "m",
                                        y = "y",
                                        boot_ci = TRUE,
                                        mc_ci = FALSE))

# Do the test 'test_parameters' on each datasets
# and add the results to 'test_out'

test_out <- power4test(object = test_out,
                       test_fun = test_parameters)

# Compute and print the rejection rates for stored tests

rejection_rates(test_out)

# See the help pages of power4test_by_n() and power4test_by_es()
# for other examples.

}
\seealso{
\code{\link[=power4test]{power4test()}},
\code{\link[=power4test_by_n]{power4test_by_n()}}, and
\code{\link[=power4test_by_es]{power4test_by_es()}}, which are
supported by this method.
}
