% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drpc.R, R/prpc.R, R/qrpc.R, R/rrpc.R
\name{revpc}
\alias{revpc}
\alias{drpc}
\alias{revpc}
\alias{prpc}
\alias{revpc}
\alias{qrpc}
\alias{revpc}
\alias{rrpc}
\title{The Reversal Power Cauchy Distribution}
\usage{
drpc(x, lambda = 1, mu = 0, sigma = 1, log = FALSE)

prpc(q, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

qrpc(p, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

rrpc(n, lambda = 1, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the reversal power Cauchy distribution with parameters mu, sigma and lambda.
}
\details{
The reversal power Cauchy distribution has density

\eqn{f\left(x\right)=\frac{\lambda}{\sigma}\left[\frac{1}{\pi\left(1+\left(\frac{x-\mu}{\sigma}\right)^{2}\right)}\right]\left[\frac{1}{\pi}\arctan\left(-\left(\frac{x-\mu}{\sigma}\right)\right)+\frac{1}{2}\right]^{\lambda-1}}{f(x)=[\lambda/\sigma][1/(\pi(1+(x-\mu)/\sigma))][(1/\pi)arctan(-(x-\mu)/\sigma)+(1/2)]^(\lambda-1)}

where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and \eqn{\lambda>0} the shape parameter.
}
\examples{
drpc(1, 1, 3, 4)
prpc(1, 1, 3, 4)
qrpc(0.2, 1, 3, 4)
rrpc(5, 2, 3, 4)
}
\references{
Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{http://conteudo.icmc.usp.br/pessoas/jlbazan/download/thesis.pdf}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.
}
