% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drpl.R, R/prpl.R, R/qrpl.R, R/rrpl.R
\name{revpl}
\alias{revpl}
\alias{drpl}
\alias{revpl}
\alias{prpl}
\alias{revpl}
\alias{qrpl}
\alias{revpl}
\alias{rrpl}
\title{The Reversal Power Logistic Distribution}
\usage{
drpl(x, lambda, mu = 0, sigma = 1)

prpl(q, lambda, mu = 0, sigma = 1)

qrpl(p, lambda, mu = 0, sigma = 1)

rrpl(n, lambda, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the reversal power logistic distribution with parameters mu, sigma and lambda.
}
\examples{
drpl(1, 1, 3, 4)
prpl(1, 1, 3, 4)
qrpl(0.2, 1, 3, 4)
rrpl(5, 2, 3, 4)
}
\references{
Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{http://conteudo.icmc.usp.br/pessoas/jlbazan/download/thesis.pdf}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.

Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions, volume 1, chapter 16. Wiley, New York.

Nagler J. (1994) Scobit: an alternative estimator to logit and probit. \emph{American Journal Political Science}, \strong{38}(1), 230-255.

Prentice, R. L. (1976) A Generalization of the probit and logit methods for dose-response curves. \emph{Biometrika}, \strong{32}, 761-768.
}
