% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_thin.R
\name{post_thin}
\alias{post_thin}
\title{Perform post-MCMC thinning}
\usage{
post_thin(post, keep_percent, keep_iters)
}
\arguments{
\item{post}{A \code{\link[coda:mcmc.list]{mcmc.list}} object.}

\item{keep_percent}{Proportion (between 0 and 1) of samples to keep from each chain.
Setting \code{keep_percent = 0.2} will remove approximately 80 percent of the samples.}

\item{keep_iters}{Number of samples to keep from each chain.}
}
\value{
A \code{\link[coda:mcmc.list]{mcmc.list}} object, identical to \code{post}, but with fewer samples of each node.
}
\description{
Removes iterations from each chain of a \code{\link[coda:mcmc.list]{mcmc.list}}
object at quasi-evenly spaced intervals. Post-MCMC thinning is useful for
developing long-running post-processing code with a smaller but otherwise identical \code{\link[coda:mcmc.list]{mcmc.list}}.
}
\details{
The samples will be removed at as evenly spaced intervals
as possible, however, this is not perfect. It is therefore recommended
to use the full posterior for final post-processing calculations, but this should be fine for
most development of long-running code.

If both \code{keep_percent} and \code{keep_iters} are supplied, an error will be returned requesting that only
one be used.
}
\note{
Iteration numbers are reset after thinning the samples. So if running \code{\link[=post_dim]{post_dim()}}
on output passed through \code{post_thin()}, you cannot trust the burn-in or thinning counts.
Again, this is not an issue for developing post-processing code.
}
\examples{
# load example mcmc.list
data(cjs)

# take note of original dimensions
post_dim(cjs)

# keep ~20\% of the samples
cjs_thin1 = post_thin(cjs, keep_percent = 0.2)

# note burn-in and thin intervals no longer correct!
# but desired outcome achieved - identical object but smaller
post_dim(cjs_thin1)

# keep 30 samples per chain
cjs_thin2 = post_thin(cjs, keep_iters = 30)
post_dim(cjs_thin2)
}
