% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_summ.R
\name{post_summ}
\alias{post_summ}
\title{Obtain posterior summaries and diagnostics of specific nodes}
\usage{
post_summ(
  post,
  params,
  digits = NULL,
  probs = c(0.5, 0.025, 0.975),
  Rhat = FALSE,
  neff = FALSE,
  mcse = FALSE,
  by_chain = FALSE,
  auto_escape = TRUE
)
}
\arguments{
\item{post}{A \code{\link[coda:mcmc.list]{mcmc.list}} object.}

\item{params}{A vector of regular expressions specifying the nodes to match for summarization.
Accepts multi-element vectors to match more than one node at a time.
See \code{\link[=match_params]{match_params()}} and \code{vignette("pattern-matching")} for more details.}

\item{digits}{Control rounding of summaries.
Passed to \code{\link[base:Round]{base::round()}} and defaults to \code{NULL}, which produces no rounding.}

\item{probs}{Posterior quantiles to calculate. Passed to \code{\link[stats:quantile]{stats::quantile()}}.
Defaults to \code{probs = c(0.5, 0.025, 0.975)} (i.e., median and equal-tailed 95 percent credible interval).}

\item{Rhat}{Calculate the Rhat convergence diagnostic using \code{\link[coda:gelman.diag]{coda::gelman.diag()}}?
Fair warning: this can take a bit of time to run on many nodes/samples.}

\item{neff}{Calculate the number of effective MCMC samples using \code{\link[coda:effectiveSize]{coda::effectiveSize()}}?
Fair warning: this can take a bit of time to run on many nodes/samples.}

\item{mcse}{Calculate the Monte Carlo standard error for the posterior mean and reported quantiles
using the \code{\link[mcmcse:mcse]{mcmcse::mcse()}} and \code{\link[mcmcse:mcse.q]{mcmcse::mcse.q()}} functions
(batch means method with batch size automatically calculated)?
Fair warning: this can take a bit of time to run on many nodes/samples.}

\item{by_chain}{Calculate posterior summaries for each chain
rather than for the aggregate across chains? Defaults to \code{FALSE}.
The arguments \code{Rhat}, \code{neff}, and \code{mcse} are ignored if \code{by_chain = TRUE}
and a warning will be returned.}

\item{auto_escape}{Automatically escape \code{"["} and \code{"]"} characters for pattern matching?
See \code{\link[=match_params]{match_params()}} for details.}
}
\value{
A \code{\link[base:matrix]{matrix}} object with summary statistics as rows and nodes as columns.
If \code{by_chain = TRUE}, an \code{\link[base:array]{array}} with chain-specific summaries as the third dimension is returned instead.
}
\description{
Allows rapid calculation of summaries and diagnostics from \strong{specific nodes}
stored in \code{\link[coda:mcmc.list]{mcmc.list}} objects.
}
\examples{
# load example mcmc.list
data(cjs)

# calculate posterior summaries for the "p" nodes
# ("p[1]" doesn't exist in model)
post_summ(cjs, "p")

# do this by chain
post_summ(cjs, "p", by_chain = TRUE)

# calculate Rhat and Neff diagnostic summaries as well
# multiple node names too
post_summ(cjs, c("b0", "p"), Rhat = TRUE, neff = TRUE)

# calculate Monte Carlo SE for mean and quantiles, with rounding
post_summ(cjs, "p", mcse = TRUE, digits = 3)

# summarize different quantiles: median and central 80\%
post_summ(cjs, "p", probs = c(0.5, 0.1, 0.9))
}
\seealso{
\code{\link[=match_params]{match_params()}}, \code{\link[coda:gelman.diag]{coda::gelman.diag()}}, \code{\link[coda:effectiveSize]{coda::effectiveSize()}}, \code{\link[mcmcse:mcse]{mcmcse::mcse()}}, \code{\link[mcmcse:mcse.q]{mcmcse::mcse.q()}}
}
