% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_checker.R
\name{input_checker}
\alias{input_checker}
\title{Helper function for input checking}
\usage{
input_checker(X_matrix, Y_vector, W_vector, specify.custom,
  test.inputs = TRUE)
}
\arguments{
\item{X_matrix}{A matrix of covariates (must be all numeric)}

\item{Y_vector}{A vector of the target variable, of same length as the number of rows of X, must be numeric}

\item{W_vector}{A vector of the treatment variable, of same length as the number of rows of X, must be numeric}

\item{specify.custom}{disables input checking by default, and leaves it to the user.}

\item{test.inputs}{If set to FALSE disables input checking, the default is TRUE.}
}
\value{
A message indicating the status of input checking, or lack thereof.
}
\description{
This functions checks the input to the double_select function for compliance with the default methods used, confirming that the inputs are viable. It is a helper - no interaction with the user should happen unless the user explicitly calls this function.
}
\details{
The function will throw a warning if it is disabled ( the input is not checked) or stop the processing if the input is checked, but incorrect. Disables checking for custom functions by default.
}
\examples{

  n = 2000; p = 10
  X = matrix(rnorm(n*p), n, p)
  W = rbinom(n, 1, 0.4 + 0.2 * (X[,1] > 0))
  Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)

input_checker(X_matrix = X, Y_vector = Y, W_vector = W,
specify.custom = NULL, test.inputs = TRUE)


}
