\name{map.embed}
\alias{map.embed}
\title{Map Embedding Accuracy}
\description{Evaluates how well a map models the underlying training data distribution.}
\usage{
map.embed(map, conf.int = 0.95, verb=FALSE, ks=FALSE)
}
\arguments{
  \item{map}{an object of type 'map'.}
  \item{conf.int}{the confidence interval of the embedding test (default 95 percent).}
  \item{verb}{a switch controlling the structure of the output value (default=FALSE)}
    \item{ks}{if true uses the Kolmogorov-Smirnov convergence test otherwise a convergence test based on variance and means is performed (default=FALSE)}
}  
\value{The embedding accuracy of the map.
	If the switch verb=TRUE then a vector of the individual feature embedding accuracies are returned.
	}
\note{map.embed has been deprecated as of this release (version 4.3.0) of the popsom package for R. map.embed has also been flagged for removal upon release of the next version of the popsom package.

The use of map.convergence, also available in the popsom package, with the argument 'verb = True' is now encouraged to explicitly compute the embedding accuracy of maps in future popsom package releases.
}
\references{
"A Population Based Convergence Criterion for Self-Organizing Maps," 
Lutz Hamel and Benjamin Ott. Proceeding of the 2012 International Conference on Data Mining (DMIN'12), 
pp98-104, July 16-19, 2012, Las Vegas Nevada, USA. 
}
\author{Lutz Hamel, Benjamin Ott, Gregory Breard, Robert Tatoian}
\examples{
data(iris)

## set data frame and labels
df <- subset(iris,select=-Species)
labels <- subset(iris,select=Species)

## build a map
m <- map.build(df, labels, xdim=15, ydim=10, train=1000)

## display the embedding accuracy of the map
map.embed(m)

## display the embedding accuracies of the individual features
data.frame(names(df),map.embed(m,verb=TRUE))
}
