% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproductive.value.R
\name{reproductive.value}
\alias{reproductive.value}
\title{Reproductive value}
\usage{
reproductive.value(A)
}
\arguments{
\item{A}{A projection matrix}
}
\value{
A vector containing the scaled reproductive values so v[1]=1
}
\description{
Calculates the reproductive values of a projection matrix
}
\details{
see section 4.5 in Caswell (2001)
}
\examples{
v <- reproductive.value(teasel)
v
dotchart(log10(v), pch=16, xlab="Reproductive value (log10)")

}
\references{
Caswell, H. 2001. Matrix population models: construction,
analysis, and interpretation, Second edition. Sinauer, Sunderland,
Massachusetts, USA.
}
\author{
Chris Stubben
}
